/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.index.settings.esnative.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexModel {
    private final String hibernateSearchIndexName;
    private final URLEncodedString elasticsearchIndexName;
    private final String mappedTypeName;
    private final RootTypeMapping mapping;
    private final IndexSettings settings;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private final Map<String, ElasticsearchIndexSchemaObjectNode> objectNodes;
    private final Map<String, ElasticsearchIndexSchemaFieldNode<?>> fieldNodes;

    public ElasticsearchIndexModel(String hibernateSearchIndexName, URLEncodedString elasticsearchIndexName, String mappedTypeName, ElasticsearchIndexSettingsBuilder settingsBuilder, RootTypeMapping mapping, ToDocumentIdentifierValueConverter<?> idDslConverter, Map<String, ElasticsearchIndexSchemaObjectNode> objectNodes, Map<String, ElasticsearchIndexSchemaFieldNode<?>> fieldNodes) {
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.mappedTypeName = mappedTypeName;
        this.settings = settingsBuilder.build();
        this.idDslConverter = idDslConverter;
        this.objectNodes = objectNodes;
        this.fieldNodes = fieldNodes;
        this.mapping = mapping;
    }

    public String getHibernateSearchIndexName() {
        return this.hibernateSearchIndexName;
    }

    public URLEncodedString getElasticsearchIndexName() {
        return this.elasticsearchIndexName;
    }

    public String getMappedTypeName() {
        return this.mappedTypeName;
    }

    public EventContext getEventContext() {
        return EventContexts.fromIndexName((String)this.hibernateSearchIndexName);
    }

    public RootTypeMapping getMapping() {
        return this.mapping;
    }

    public IndexSettings getSettings() {
        return this.settings;
    }

    public ToDocumentIdentifierValueConverter<?> getIdDslConverter() {
        return this.idDslConverter;
    }

    public ElasticsearchIndexSchemaObjectNode getObjectNode(String absolutePath) {
        return this.objectNodes.get(absolutePath);
    }

    public ElasticsearchIndexSchemaFieldNode<?> getFieldNode(String absoluteFieldPath) {
        return this.fieldNodes.get(absoluteFieldPath);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "elasticsearchIndexName=" + this.elasticsearchIndexName + ", mapping=" + this.mapping + "]";
    }
}

