/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.dialect.impl.ElasticsearchDialectFactory;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.ElasticsearchProtocolDialect;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.util.impl.ElasticsearchJsonSyntaxHelper;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchLinkImpl
implements ElasticsearchLink {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanHolder<? extends ElasticsearchClientFactory> clientFactoryHolder;
    private final ThreadPoolProvider threadPoolProvider;
    private final GsonProvider defaultGsonProvider;
    private final boolean logPrettyPrinting;
    private final ElasticsearchDialectFactory dialectFactory;
    private final Optional<ElasticsearchVersion> configuredVersionOptional;
    private ElasticsearchClientImplementor clientImplementor;
    private ElasticsearchVersion elasticsearchVersion;
    private GsonProvider gsonProvider;
    private ElasticsearchJsonSyntaxHelper jsonSyntaxHelper;
    private ElasticsearchWorkBuilderFactory workBuilderFactory;
    private ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;

    ElasticsearchLinkImpl(BeanHolder<? extends ElasticsearchClientFactory> clientFactoryHolder, ThreadPoolProvider threadPoolProvider, GsonProvider defaultGsonProvider, boolean logPrettyPrinting, ElasticsearchDialectFactory dialectFactory, Optional<ElasticsearchVersion> configuredVersionOptional) {
        this.clientFactoryHolder = clientFactoryHolder;
        this.threadPoolProvider = threadPoolProvider;
        this.defaultGsonProvider = defaultGsonProvider;
        this.logPrettyPrinting = logPrettyPrinting;
        this.dialectFactory = dialectFactory;
        this.configuredVersionOptional = configuredVersionOptional;
    }

    @Override
    public ElasticsearchClient getClient() {
        this.checkStarted();
        return this.clientImplementor;
    }

    @Override
    public GsonProvider getGsonProvider() {
        this.checkStarted();
        return this.gsonProvider;
    }

    @Override
    public ElasticsearchJsonSyntaxHelper getJsonSyntaxHelper() {
        return this.jsonSyntaxHelper;
    }

    @Override
    public ElasticsearchWorkBuilderFactory getWorkBuilderFactory() {
        this.checkStarted();
        return this.workBuilderFactory;
    }

    @Override
    public ElasticsearchSearchResultExtractorFactory getSearchResultExtractorFactory() {
        this.checkStarted();
        return this.searchResultExtractorFactory;
    }

    ElasticsearchVersion getElasticsearchVersion() {
        this.checkStarted();
        return this.elasticsearchVersion;
    }

    void onStart(ConfigurationPropertySource propertySource) {
        if (this.clientImplementor == null) {
            ElasticsearchVersion configuredVersion;
            this.clientImplementor = ((ElasticsearchClientFactory)this.clientFactoryHolder.get()).create(propertySource, this.threadPoolProvider, this.defaultGsonProvider);
            this.clientFactoryHolder.close();
            this.elasticsearchVersion = ElasticsearchClientUtils.getElasticsearchVersion(this.clientImplementor);
            if (this.configuredVersionOptional.isPresent() && !(configuredVersion = this.configuredVersionOptional.get()).matches(this.elasticsearchVersion)) {
                throw log.unexpectedElasticsearchVersion(configuredVersion, this.elasticsearchVersion);
            }
            ElasticsearchProtocolDialect protocolDialect = this.dialectFactory.createProtocolDialect(this.elasticsearchVersion);
            this.gsonProvider = GsonProvider.create(protocolDialect::createGsonBuilderBase, this.logPrettyPrinting);
            this.jsonSyntaxHelper = protocolDialect.createJsonSyntaxHelper();
            this.workBuilderFactory = protocolDialect.createWorkBuilderFactory(this.gsonProvider);
            this.searchResultExtractorFactory = protocolDialect.createSearchResultExtractorFactory();
        }
    }

    void onStop() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.clientFactoryHolder);
            closer.push(Closeable::close, (Object)this.clientImplementor);
        }
    }

    private void checkStarted() {
        if (this.clientImplementor == null) {
            throw new AssertionFailure("Attempt to retrieve Elasticsearch client or related information before the backend was started.There is probably a bug in Hibernate Search, please report it.");
        }
    }
}

