/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreatorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaDropperImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigratorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidatorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

public class ElasticsearchIndexAdministrationClient {
    private final ElasticsearchSchemaCreator schemaCreator;
    private final ElasticsearchSchemaDropper schemaDropper;
    private final ElasticsearchSchemaValidator schemaValidator;
    private final ElasticsearchSchemaMigrator schemaMigrator;
    private final URLEncodedString elasticsearchIndexName;
    private final IndexMetadata expectedMetadata;

    public ElasticsearchIndexAdministrationClient(ElasticsearchLink link, ElasticsearchWorkOrchestrator workOrchestrator, URLEncodedString elasticsearchIndexName, IndexMetadata expectedMetadata) {
        ElasticsearchSchemaAccessor schemaAccessor = new ElasticsearchSchemaAccessor(link, workOrchestrator);
        this.schemaCreator = new ElasticsearchSchemaCreatorImpl(schemaAccessor);
        this.schemaDropper = new ElasticsearchSchemaDropperImpl(schemaAccessor);
        this.schemaValidator = new ElasticsearchSchemaValidatorImpl(schemaAccessor);
        this.schemaMigrator = new ElasticsearchSchemaMigratorImpl(schemaAccessor, this.schemaValidator);
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.expectedMetadata = expectedMetadata;
    }

    public CompletableFuture<?> createIfAbsent(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return this.schemaCreator.createIndexIfAbsent(this.expectedMetadata, executionOptions);
    }

    public CompletableFuture<?> dropAndCreate(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return this.schemaDropper.dropIfExisting(this.elasticsearchIndexName).thenCompose(ignored -> this.schemaCreator.createIndex(this.expectedMetadata, executionOptions));
    }

    public CompletableFuture<?> dropIfExisting(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return this.schemaDropper.dropIfExisting(this.elasticsearchIndexName);
    }

    public CompletableFuture<?> update(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return this.schemaCreator.createIndexIfAbsent(this.expectedMetadata, executionOptions).thenCompose(createdIndex -> {
            if (!createdIndex.booleanValue()) {
                return this.schemaMigrator.migrate(this.expectedMetadata);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<?> validate(ElasticsearchIndexLifecycleExecutionOptions executionOptions, ContextualFailureCollector failureCollector) {
        return this.schemaCreator.checkIndexExists(this.elasticsearchIndexName, executionOptions).thenCompose(ignored -> this.schemaValidator.validate(this.expectedMetadata, failureCollector));
    }
}

