/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.settings.esnative.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaMigratorImpl
implements ElasticsearchSchemaMigrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaValidator schemaValidator;

    public ElasticsearchSchemaMigratorImpl(ElasticsearchSchemaAccessor schemaAccessor, ElasticsearchSchemaValidator schemaValidator) {
        this.schemaAccessor = schemaAccessor;
        this.schemaValidator = schemaValidator;
    }

    @Override
    public CompletableFuture<?> migrate(IndexMetadata indexMetadata) {
        URLEncodedString indexName = indexMetadata.getName();
        IndexSettings settings = indexMetadata.getSettings();
        CompletionStage<Object> settingsMigration = settings.isEmpty() ? CompletableFuture.completedFuture(null) : this.schemaValidator.isSettingsValid(indexMetadata).thenCompose(valid -> {
            if (valid.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.doMigrateSettings(indexName, settings);
        });
        return ((CompletableFuture)settingsMigration.thenCompose(ignored -> this.doMigrateMapping(indexName, indexMetadata.getMapping()))).exceptionally(Futures.handler(e -> {
            throw log.schemaUpdateFailed(indexName, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    private CompletableFuture<?> doMigrateSettings(URLEncodedString indexName, IndexSettings settings) {
        return this.schemaAccessor.closeIndex(indexName).thenCompose(ignored -> Futures.whenCompleteExecute(this.schemaAccessor.updateSettings(indexName, settings), () -> this.schemaAccessor.openIndex(indexName)));
    }

    private CompletableFuture<?> doMigrateMapping(URLEncodedString indexName, RootTypeMapping mapping) {
        return this.schemaAccessor.putMapping(indexName, mapping);
    }
}

