/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.multitenancy.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.IndexSchemaRootContributor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class NoMultiTenancyStrategy
implements MultiTenancyStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final NoMultiTenancyIdProjectionExtractionHelper idProjectionExtractionHelper = new NoMultiTenancyIdProjectionExtractionHelper();

    @Override
    public boolean isMultiTenancySupported() {
        return false;
    }

    @Override
    public Optional<IndexSchemaRootContributor> getIndexSchemaRootContributor() {
        return Optional.empty();
    }

    @Override
    public String toElasticsearchId(String tenantId, String id) {
        return id;
    }

    @Override
    public Optional<DocumentMetadataContributor> getDocumentMetadataContributor() {
        return Optional.empty();
    }

    @Override
    public JsonObject decorateJsonQuery(JsonObject originalJsonQuery, String tenantId) {
        return originalJsonQuery;
    }

    public NoMultiTenancyIdProjectionExtractionHelper getIdProjectionExtractionHelper() {
        return this.idProjectionExtractionHelper;
    }

    @Override
    public void checkTenantId(String tenantId, EventContext backendContext) {
        if (tenantId != null) {
            throw log.tenantIdProvidedButMultiTenancyDisabled(tenantId, backendContext);
        }
    }

    private static final class NoMultiTenancyIdProjectionExtractionHelper
    implements ProjectionExtractionHelper<String> {
        private static final JsonAccessor<String> HIT_ID_ACCESSOR = JsonAccessor.root().property("_id").asString();

        private NoMultiTenancyIdProjectionExtractionHelper() {
        }

        @Override
        public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        }

        @Override
        public String extract(JsonObject hit, SearchProjectionExtractContext context) {
            return HIT_ID_ACCESSOR.get(hit).orElseThrow(log::elasticsearchResponseMissingData);
        }
    }
}

