/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchRefreshableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResult;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResultItemExtractor;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchDefaultWorkSequenceBuilder
implements ElasticsearchWorkSequenceBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier;
    private final BulkResultExtractionStepImpl bulkResultExtractionStep = new BulkResultExtractionStepImpl();
    private CompletableFuture<?> currentlyBuildingSequenceTail;
    private SequenceContext currentlyBuildingSequenceContext;

    ElasticsearchDefaultWorkSequenceBuilder(Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier) {
        this.contextSupplier = contextSupplier;
    }

    @Override
    public void init(CompletableFuture<?> previous) {
        this.currentlyBuildingSequenceTail = previous.handle((ignoredResult, ignoredThrowable) -> null);
        this.currentlyBuildingSequenceContext = new SequenceContext(this.contextSupplier.get());
    }

    @Override
    public <T> CompletableFuture<T> addNonBulkExecution(ElasticsearchWork<T> work) {
        SequenceContext sequenceContext = this.currentlyBuildingSequenceContext;
        NonBulkedWorkExecutionState workExecutionState = new NonBulkedWorkExecutionState(sequenceContext, work);
        CompletionStage handledWorkExecutionFuture = ((CompletableFuture)this.currentlyBuildingSequenceTail.whenComplete(Futures.handler(workExecutionState::onPreviousWorkComplete))).thenCompose(Futures.safeComposer(workExecutionState::onPreviousWorkSuccess));
        this.currentlyBuildingSequenceTail = handledWorkExecutionFuture;
        return workExecutionState.workFutureForCaller;
    }

    @Override
    public CompletableFuture<BulkResult> addBulkExecution(CompletableFuture<? extends ElasticsearchWork<BulkResult>> workFuture) {
        SequenceContext currentSequenceContext = this.currentlyBuildingSequenceContext;
        CompletionStage bulkWorkResultFuture = ((CompletableFuture)this.currentlyBuildingSequenceTail.thenCombine(workFuture, (ignored, work) -> work)).thenCompose(currentSequenceContext::execute);
        this.currentlyBuildingSequenceTail = ((CompletableFuture)bulkWorkResultFuture).exceptionally(Futures.handler(throwable -> {
            throw new PreviousWorkException((Throwable)throwable);
        }));
        return bulkWorkResultFuture;
    }

    @Override
    public ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep addBulkResultExtraction(CompletableFuture<BulkResult> bulkResultFuture) {
        SequenceContext currentSequenceContext = this.currentlyBuildingSequenceContext;
        CompletionStage extractorFuture = bulkResultFuture.thenApply(currentSequenceContext::addContext);
        this.bulkResultExtractionStep.init((CompletableFuture<BulkResultItemExtractor>)extractorFuture);
        return this.bulkResultExtractionStep;
    }

    @Override
    public CompletableFuture<Void> build() {
        SequenceContext sequenceContext = this.currentlyBuildingSequenceContext;
        return Futures.whenCompleteExecute(this.currentlyBuildingSequenceTail, sequenceContext::onSequenceComplete).exceptionally(Futures.handler(sequenceContext::onSequenceFailed));
    }

    private static final class BulkedWorkExecutionState<R>
    extends AbstractWorkExecutionState<R> {
        private final BulkableElasticsearchWork<R> bulkedWork;
        private final int index;
        private BulkResultItemExtractor extractor;

        private BulkedWorkExecutionState(SequenceContext sequenceContext, BulkableElasticsearchWork<R> bulkedWork, int index) {
            super(sequenceContext, bulkedWork);
            this.bulkedWork = bulkedWork;
            this.index = index;
        }

        void onBulkWorkComplete(BulkResultItemExtractor ignored, Throwable throwable) {
            if (throwable == null) {
                return;
            }
            if (throwable instanceof PreviousWorkException) {
                this.skip(throwable);
            } else {
                this.failBecauseBulkFailed(throwable);
            }
        }

        CompletableFuture<R> onBulkWorkSuccess(BulkResultItemExtractor extractor) {
            this.extractor = extractor;
            CompletableFuture workExecutionFuture = Futures.create(this::extract);
            return this.addPostExecutionHandlers(workExecutionFuture);
        }

        private CompletableFuture<R> extract() {
            return this.extractor.extract(this.bulkedWork, this.index);
        }

        private void failBecauseBulkFailed(Throwable throwable) {
            this.fail((Throwable)log.elasticsearchFailedBecauseOfBulkFailure(throwable));
        }
    }

    private static final class NonBulkedWorkExecutionState<R>
    extends AbstractWorkExecutionState<R> {
        private NonBulkedWorkExecutionState(SequenceContext sequenceContext, ElasticsearchWork<R> work) {
            super(sequenceContext, work);
        }

        void onPreviousWorkComplete(Object ignored, Throwable throwable) {
            if (throwable != null) {
                this.skip(throwable);
            }
        }

        CompletableFuture<R> onPreviousWorkSuccess(Object ignored) {
            CompletableFuture workExecutionFuture = this.work.execute(this.sequenceContext.executionContext);
            return this.addPostExecutionHandlers(workExecutionFuture);
        }
    }

    private static abstract class AbstractWorkExecutionState<T> {
        protected final SequenceContext sequenceContext;
        protected final ElasticsearchWork<T> work;
        final CompletableFuture<T> workFutureForCaller = new CompletableFuture();

        private AbstractWorkExecutionState(SequenceContext sequenceContext, ElasticsearchWork<T> work) {
            this.sequenceContext = sequenceContext;
            this.work = work;
        }

        protected CompletableFuture<T> addPostExecutionHandlers(CompletableFuture<T> workExecutionFuture) {
            ((CompletableFuture)workExecutionFuture.thenCombine((CompletionStage)this.sequenceContext.refreshFuture, (workResult, refreshResult) -> workResult)).whenComplete(Futures.copyHandler(this.workFutureForCaller));
            return workExecutionFuture.exceptionally(Futures.handler(this::fail));
        }

        protected void skip(Throwable throwable) {
            Throwable skippingCause = throwable instanceof PreviousWorkException ? throwable.getCause() : throwable;
            this.workFutureForCaller.completeExceptionally((Throwable)log.elasticsearchSkippedBecauseOfPreviousWork(skippingCause));
        }

        protected T fail(Throwable throwable) {
            this.workFutureForCaller.completeExceptionally(throwable);
            throw new PreviousWorkException(throwable);
        }
    }

    private static final class SequenceContext {
        private final ElasticsearchRefreshableWorkExecutionContext executionContext;
        private final CompletableFuture<Void> refreshFuture;

        SequenceContext(ElasticsearchRefreshableWorkExecutionContext executionContext) {
            this.executionContext = executionContext;
            this.refreshFuture = new CompletableFuture();
        }

        <T> CompletionStage<T> execute(ElasticsearchWork<T> work) {
            return work.execute(this.executionContext);
        }

        public BulkResultItemExtractor addContext(BulkResult bulkResult) {
            return bulkResult.withContext(this.executionContext);
        }

        CompletionStage<Void> onSequenceComplete() {
            return this.executionContext.executePendingRefreshes().whenComplete(Futures.copyHandler(this.refreshFuture));
        }

        <T> T onSequenceFailed(Throwable throwable) {
            if (!(throwable instanceof PreviousWorkException)) {
                throw Throwables.toRuntimeException((Throwable)throwable);
            }
            return null;
        }
    }

    private static final class PreviousWorkException
    extends RuntimeException {
        public PreviousWorkException(Throwable cause) {
            super(cause);
        }
    }

    private final class BulkResultExtractionStepImpl
    implements ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep {
        private CompletableFuture<BulkResultItemExtractor> extractorFuture;

        private BulkResultExtractionStepImpl() {
        }

        void init(CompletableFuture<BulkResultItemExtractor> extractorFuture) {
            this.extractorFuture = extractorFuture;
        }

        @Override
        public <T> CompletableFuture<T> add(BulkableElasticsearchWork<T> bulkedWork, int index) {
            SequenceContext sequenceContext = ElasticsearchDefaultWorkSequenceBuilder.this.currentlyBuildingSequenceContext;
            BulkedWorkExecutionState workExecutionState = new BulkedWorkExecutionState(sequenceContext, bulkedWork, index);
            CompletionStage handledWorkExecutionFuture = ((CompletableFuture)this.extractorFuture.whenComplete(Futures.handler(workExecutionState::onBulkWorkComplete))).thenCompose(workExecutionState::onBulkWorkSuccess);
            ElasticsearchDefaultWorkSequenceBuilder.this.currentlyBuildingSequenceTail = CompletableFuture.allOf(new CompletableFuture[]{ElasticsearchDefaultWorkSequenceBuilder.this.currentlyBuildingSequenceTail, handledWorkExecutionFuture});
            return workExecutionState.workFutureForCaller;
        }
    }
}

