/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextMatchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextPhrasePredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextWildcardPredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

public class ElasticsearchTextFieldPredicateBuilderFactory
extends ElasticsearchStandardFieldPredicateBuilderFactory<String> {
    private final String type;
    private final String analyzer;
    private final String normalizer;

    public ElasticsearchTextFieldPredicateBuilderFactory(boolean searchable, DslConverter<?, ? extends String> converter, DslConverter<String, ? extends String> rawConverter, ElasticsearchFieldCodec<String> codec, PropertyMapping mapping) {
        super(searchable, converter, rawConverter, codec);
        this.type = mapping.getType();
        this.analyzer = mapping.getSearchAnalyzer() != null ? mapping.getSearchAnalyzer() : mapping.getAnalyzer();
        this.normalizer = mapping.getNormalizer();
    }

    @Override
    public boolean hasCompatibleAnalyzer(ElasticsearchFieldPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchTextFieldPredicateBuilderFactory castedOther = (ElasticsearchTextFieldPredicateBuilderFactory)other;
        return Objects.equals(this.analyzer, castedOther.analyzer) && Objects.equals(this.normalizer, castedOther.normalizer);
    }

    @Override
    public MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> createMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ElasticsearchCompatibilityChecker converterChecker, ElasticsearchCompatibilityChecker analyzerChecker) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchTextMatchPredicateBuilder(searchContext, absoluteFieldPath, this.converter, (DslConverter<String, ? extends String>)this.rawConverter, converterChecker, this.codec, this.type, analyzerChecker);
    }

    @Override
    public PhrasePredicateBuilder<ElasticsearchSearchPredicateBuilder> createPhrasePredicateBuilder(String absoluteFieldPath, ElasticsearchCompatibilityChecker analyzerChecker) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchTextPhrasePredicateBuilder(absoluteFieldPath, analyzerChecker);
    }

    @Override
    public WildcardPredicateBuilder<ElasticsearchSearchPredicateBuilder> createWildcardPredicateBuilder(String absoluteFieldPath) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchTextWildcardPredicateBuilder(absoluteFieldPath);
    }

    @Override
    public ElasticsearchSimpleQueryStringPredicateBuilderFieldState createSimpleQueryStringFieldContext(String absoluteFieldPath) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchSimpleQueryStringPredicateBuilderFieldState(absoluteFieldPath);
    }
}

