/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchStandardFieldProjectionBuilderFactory<F>
implements ElasticsearchFieldProjectionBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean projectable;
    private final ProjectionConverter<? super F, ?> converter;
    private final ProjectionConverter<? super F, F> rawConverter;
    private final ElasticsearchFieldCodec<F> codec;

    public ElasticsearchStandardFieldProjectionBuilderFactory(boolean projectable, ProjectionConverter<? super F, ?> converter, ProjectionConverter<? super F, F> rawConverter, ElasticsearchFieldCodec<F> codec) {
        this.projectable = projectable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    @Override
    public <T> FieldProjectionBuilder<T> createFieldValueProjectionBuilder(Set<String> indexNames, String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        ElasticsearchStandardFieldProjectionBuilderFactory.checkProjectable(absoluteFieldPath, this.projectable);
        ProjectionConverter<F, ?> requestConverter = this.getConverter(convert);
        if (!requestConverter.isConvertedTypeAssignableTo(expectedType)) {
            throw log.invalidProjectionInvalidType(absoluteFieldPath, expectedType, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
        return new ElasticsearchFieldProjectionBuilder(indexNames, absoluteFieldPath, requestConverter, this.codec);
    }

    @Override
    public DistanceToFieldProjectionBuilder createDistanceProjectionBuilder(Set<String> indexNames, String absoluteFieldPath, String nestedPath, GeoPoint center) {
        throw log.distanceOperationsNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public boolean hasCompatibleCodec(ElasticsearchFieldProjectionBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldProjectionBuilderFactory castedOther = (ElasticsearchStandardFieldProjectionBuilderFactory)other;
        return this.projectable == castedOther.projectable && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean hasCompatibleConverter(ElasticsearchFieldProjectionBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldProjectionBuilderFactory castedOther = (ElasticsearchStandardFieldProjectionBuilderFactory)other;
        return this.converter.isCompatibleWith(castedOther.converter);
    }

    private static void checkProjectable(String absoluteFieldPath, boolean projectable) {
        if (!projectable) {
            throw log.nonProjectableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }

    private ProjectionConverter<? super F, ?> getConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawConverter;
            }
        }
        return this.converter;
    }
}

