/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchDocumentReference;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.DeleteWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleBulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentElasticsearchWork;
import org.hibernate.search.engine.backend.common.DocumentReference;

public class DeleteWork
extends AbstractSimpleBulkableElasticsearchWork<Void>
implements SingleDocumentElasticsearchWork<Void> {
    private static final ElasticsearchRequestSuccessAssessor SUCCESS_ASSESSOR = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(404).build();
    private final String mappedTypeName;
    private final URLEncodedString id;

    private DeleteWork(Builder builder) {
        super(builder);
        this.mappedTypeName = builder.mappedTypeName;
        this.id = builder.id;
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
        return null;
    }

    @Override
    public DocumentReference getDocumentReference() {
        return new ElasticsearchDocumentReference(this.mappedTypeName, this.id.original);
    }

    public static class Builder
    extends AbstractSimpleBulkableElasticsearchWork.AbstractBuilder<Builder>
    implements DeleteWorkBuilder {
        private final String mappedTypeName;
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final URLEncodedString id;
        private final String routingKey;

        public static Builder forElasticsearch67AndBelow(String mappedTypeName, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, URLEncodedString id, String routingKey) {
            return new Builder(mappedTypeName, elasticsearchIndexName, typeName, id, routingKey);
        }

        public static Builder forElasticsearch7AndAbove(String mappedTypeName, URLEncodedString elasticsearchIndexName, URLEncodedString id, String routingKey) {
            return new Builder(mappedTypeName, elasticsearchIndexName, null, id, routingKey);
        }

        private Builder(String mappedTypeName, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, URLEncodedString id, String routingKey) {
            super(elasticsearchIndexName, SUCCESS_ASSESSOR);
            this.mappedTypeName = mappedTypeName;
            this.indexName = elasticsearchIndexName;
            this.typeName = typeName;
            this.id = id;
            this.routingKey = routingKey;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.delete().pathComponent(this.indexName).pathComponent(this.typeName != null ? this.typeName : Paths._DOC).pathComponent(this.id);
            if (this.routingKey != null) {
                builder.param("routing", this.routingKey);
            }
            return builder.build();
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            JsonObject delete = new JsonObject();
            delete.addProperty("_index", this.indexName.original);
            if (this.typeName != null) {
                delete.addProperty("_type", this.typeName.original);
            }
            delete.addProperty("_id", this.id.original);
            if (this.routingKey != null) {
                delete.addProperty("routing", this.routingKey);
            }
            JsonObject result = new JsonObject();
            result.add("delete", (JsonElement)delete);
            return result;
        }

        @Override
        public DeleteWork build() {
            return new DeleteWork(this);
        }
    }
}

