/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

/**
 * An object responsible for validating type mappings retrieved from an existing Elasticsearch instance
 * against Hibernate Search-generated type mappings.
 */
public interface ElasticsearchSchemaValidator {

	/**
	 * Validate actual index metadata, pushing any validation failure to the given collector.
	 *
	 * @param expectedIndexMetadata The expected metadata, generated by Hibernate Search.
	 * @param actualIndexMetadata The actual metadata, retrieved from Elasticsearch.
	 * @param contextualFailureCollector A collector for validation failures.
	 */
	void validate(IndexMetadata expectedIndexMetadata,
			IndexMetadata actualIndexMetadata,
			ContextualFailureCollector contextualFailureCollector);

	/**
	 * Validate index settings only, returning a boolean indicating
	 * whether the actual settings are valid or not.
	 *
	 * @param expectedIndexMetadata The expected metadata, generated by Hibernate Search.
	 * @param actualIndexMetadata The actual metadata, retrieved from Elasticsearch.
	 * @return {@code true} if the actual settings are valid, {@code false} otherwise.
	 */
	boolean isSettingsValid(IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata);

}
