/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import org.apache.http.HttpHost;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class ServerUris {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HttpHost[] hosts;
    private final boolean sslEnabled;

    private ServerUris(HttpHost[] hosts, boolean sslEnabled) {
        this.hosts = hosts;
        this.sslEnabled = sslEnabled;
    }

    static ServerUris fromStrings(String protocol, List<String> hostAndPortStrings) {
        HttpHost[] hosts = new HttpHost[hostAndPortStrings.size()];
        String scheme = protocol.toLowerCase(Locale.ROOT);
        for (int i = 0; i < hostAndPortStrings.size(); ++i) {
            HttpHost host;
            hosts[i] = host = ServerUris.createHttpHost(scheme, hostAndPortStrings.get(i));
        }
        return new ServerUris(hosts, "https".equals(scheme));
    }

    private static HttpHost createHttpHost(String scheme, String hostAndPort) {
        String host;
        if (hostAndPort.indexOf("://") >= 0) {
            throw log.invalidHostAndPort(hostAndPort, null);
        }
        int port = -1;
        int portIdx = hostAndPort.lastIndexOf(58);
        if (portIdx < 0) {
            host = hostAndPort;
        } else {
            try {
                port = Integer.parseInt(hostAndPort.substring(portIdx + 1));
            }
            catch (NumberFormatException e) {
                throw log.invalidHostAndPort(hostAndPort, e);
            }
            host = hostAndPort.substring(0, portIdx);
        }
        return new HttpHost(host, port, scheme);
    }

    HttpHost[] asHostsArray() {
        return this.hosts;
    }

    boolean isSslEnabled() {
        return this.sslEnabled;
    }
}

