/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldReference;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexObjectFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.spi.NoOpDocumentElement;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDocumentObjectBuilder
implements DocumentElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchIndexSchemaObjectNode schemaNode;
    private final JsonObject content;

    public ElasticsearchDocumentObjectBuilder() {
        this(ElasticsearchIndexSchemaObjectNode.root(), new JsonObject());
    }

    ElasticsearchDocumentObjectBuilder(ElasticsearchIndexSchemaObjectNode schemaNode, JsonObject content) {
        this.schemaNode = schemaNode;
        this.content = content;
    }

    public <F> void addValue(IndexFieldReference<F> fieldReference, F value) {
        ElasticsearchIndexFieldReference elasticsearchFieldReference = (ElasticsearchIndexFieldReference)fieldReference;
        if (!elasticsearchFieldReference.isEnabled()) {
            return;
        }
        ElasticsearchIndexSchemaFieldNode fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        this.checkTreeConsistency(fieldSchemaNode.getParent());
        if (!fieldSchemaNode.isMultiValued() && elasticsearchFieldReference.hasValueIn(this.content)) {
            throw log.multipleValuesForSingleValuedField(fieldSchemaNode.getAbsolutePath());
        }
        elasticsearchFieldReference.addTo(this.content, value);
    }

    public DocumentElement addObject(IndexObjectFieldReference fieldReference) {
        ElasticsearchIndexObjectFieldReference elasticsearchFieldReference = (ElasticsearchIndexObjectFieldReference)fieldReference;
        if (!elasticsearchFieldReference.isEnabled()) {
            return NoOpDocumentElement.get();
        }
        ElasticsearchIndexSchemaObjectNode fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        this.checkTreeConsistency(fieldSchemaNode.getParent());
        if (!fieldSchemaNode.isMultiValued() && elasticsearchFieldReference.hasValueIn(this.content)) {
            throw log.multipleValuesForSingleValuedField(fieldSchemaNode.getAbsolutePath());
        }
        JsonObject jsonObject = new JsonObject();
        elasticsearchFieldReference.addTo(this.content, jsonObject);
        return new ElasticsearchDocumentObjectBuilder(fieldSchemaNode, jsonObject);
    }

    public void addNullObject(IndexObjectFieldReference fieldReference) {
        ElasticsearchIndexObjectFieldReference elasticsearchFieldReference = (ElasticsearchIndexObjectFieldReference)fieldReference;
        if (!elasticsearchFieldReference.isEnabled()) {
            return;
        }
        ElasticsearchIndexSchemaObjectNode fieldSchemaNode = elasticsearchFieldReference.getSchemaNode();
        this.checkTreeConsistency(fieldSchemaNode.getParent());
        if (!fieldSchemaNode.isMultiValued() && elasticsearchFieldReference.hasValueIn(this.content)) {
            throw log.multipleValuesForSingleValuedField(fieldSchemaNode.getAbsolutePath());
        }
        elasticsearchFieldReference.addTo(this.content, null);
    }

    public JsonObject build() {
        return this.content;
    }

    private void checkTreeConsistency(ElasticsearchIndexSchemaObjectNode expectedParentNode) {
        if (!Objects.equals(expectedParentNode, this.schemaNode)) {
            throw log.invalidFieldForDocumentElement(expectedParentNode.getAbsolutePath(), this.schemaNode.getAbsolutePath());
        }
    }
}

