/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.engine.backend.document.IndexFieldReference;

public class ElasticsearchIndexFieldReference<F>
implements IndexFieldReference<F> {
    private final JsonAccessor<JsonElement> relativeAccessor;
    private ElasticsearchIndexSchemaFieldNode<F> schemaNode;

    public ElasticsearchIndexFieldReference(JsonAccessor<JsonElement> relativeAccessor) {
        this.relativeAccessor = relativeAccessor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[schemaNode=" + this.schemaNode + ", relativeAccessor=" + this.relativeAccessor + "]";
    }

    public void enable(ElasticsearchIndexSchemaFieldNode<F> schemaNode) {
        this.schemaNode = schemaNode;
    }

    boolean isEnabled() {
        return this.schemaNode != null;
    }

    ElasticsearchIndexSchemaFieldNode<F> getSchemaNode() {
        return this.schemaNode;
    }

    void addTo(JsonObject parent, F value) {
        this.relativeAccessor.add(parent, this.schemaNode.getCodec().encode(value));
    }

    boolean hasValueIn(JsonObject parent) {
        return this.relativeAccessor.hasExplicitValue(parent);
    }
}

