/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaCreatorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaDropperImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigratorImpl;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidatorImpl;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchEventContexts;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

public class ElasticsearchIndexAdministrationClient {
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaCreator schemaCreator;
    private final ElasticsearchSchemaDropper schemaDropper;
    private final ElasticsearchSchemaValidator schemaValidator;
    private final ElasticsearchSchemaMigrator schemaMigrator;
    private final IndexNames indexNames;
    private final IndexMetadata expectedMetadata;

    public ElasticsearchIndexAdministrationClient(ElasticsearchWorkBuilderFactory workBuilderFactory, ElasticsearchWorkOrchestrator workOrchestrator, IndexLayoutStrategy indexLayoutStrategy, IndexNames indexNames, IndexMetadata expectedMetadata) {
        this.schemaAccessor = new ElasticsearchSchemaAccessor(workBuilderFactory, workOrchestrator);
        this.schemaCreator = new ElasticsearchSchemaCreatorImpl(this.schemaAccessor, indexLayoutStrategy);
        this.schemaDropper = new ElasticsearchSchemaDropperImpl(this.schemaAccessor);
        this.schemaValidator = new ElasticsearchSchemaValidatorImpl();
        this.schemaMigrator = new ElasticsearchSchemaMigratorImpl(this.schemaAccessor, this.schemaValidator);
        this.indexNames = indexNames;
        this.expectedMetadata = expectedMetadata;
    }

    public CompletableFuture<?> createIfAbsent(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return this.schemaCreator.createIndexIfAbsent(this.indexNames, this.expectedMetadata).thenCompose(ignored -> this.schemaAccessor.waitForIndexStatus(this.indexNames, executionOptions));
    }

    public CompletableFuture<?> dropAndCreate(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return ((CompletableFuture)this.schemaDropper.dropIfExisting(this.indexNames).thenCompose(ignored -> this.schemaCreator.createIndexAssumeNonExisting(this.indexNames, this.expectedMetadata))).thenCompose(ignored -> this.schemaAccessor.waitForIndexStatus(this.indexNames, executionOptions));
    }

    public CompletableFuture<?> dropIfExisting(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return this.schemaDropper.dropIfExisting(this.indexNames);
    }

    public CompletableFuture<?> update(ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        return ((CompletableFuture)this.schemaCreator.createIndexIfAbsent(this.indexNames, this.expectedMetadata).thenCompose(existingIndexMetadata -> {
            if (existingIndexMetadata != null) {
                return this.schemaMigrator.migrate(URLEncodedString.fromString(existingIndexMetadata.getPrimaryName()), this.expectedMetadata, existingIndexMetadata.getMetadata());
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(ignored -> this.schemaAccessor.waitForIndexStatus(this.indexNames, executionOptions));
    }

    public CompletableFuture<?> validate(ElasticsearchIndexLifecycleExecutionOptions executionOptions, ContextualFailureCollector failureCollector) {
        return ((CompletableFuture)this.schemaAccessor.getCurrentIndexMetadata(this.indexNames).thenAccept(actualIndexMetadata -> this.schemaValidator.validate(this.expectedMetadata, actualIndexMetadata.getMetadata(), failureCollector.withContext(ElasticsearchEventContexts.getSchemaValidation())))).thenCompose(ignored -> failureCollector.hasFailure() ? CompletableFuture.completedFuture(null) : this.schemaAccessor.waitForIndexStatus(this.indexNames, executionOptions));
    }
}

