/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExistingIndexMetadata;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaAccessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchWorkBuilderFactory workBuilderFactory;
    private final ElasticsearchWorkOrchestrator orchestrator;

    public ElasticsearchSchemaAccessor(ElasticsearchWorkBuilderFactory workBuilderFactory, ElasticsearchWorkOrchestrator orchestrator) {
        this.workBuilderFactory = workBuilderFactory;
        this.orchestrator = orchestrator;
    }

    public CompletableFuture<?> createIndexAssumeNonExisting(URLEncodedString primaryIndexName, Map<String, IndexAliasDefinition> aliases, IndexSettings settings, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().createIndex(primaryIndexName).aliases(aliases).settings(settings).mapping(mapping).build();
        return this.execute((ElasticsearchWork)work);
    }

    public CompletableFuture<Boolean> createIndexIgnoreExisting(URLEncodedString primaryIndexName, Map<String, IndexAliasDefinition> aliases, IndexSettings settings, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().createIndex(primaryIndexName).aliases(aliases).settings(settings).mapping(mapping).ignoreExisting().build();
        return this.execute((ElasticsearchWork)work).thenApply(CreateIndexResult.CREATED::equals);
    }

    public CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadata(IndexNames indexNames) {
        return this.getCurrentIndexMetadata(indexNames, false);
    }

    public CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadataOrNull(IndexNames indexNames) {
        return this.getCurrentIndexMetadata(indexNames, true);
    }

    private CompletableFuture<ExistingIndexMetadata> getCurrentIndexMetadata(IndexNames indexNames, boolean allowNull) {
        Object work = this.getWorkFactory().getIndexMetadata().index(indexNames.getWrite()).index(indexNames.getRead()).build();
        return ((CompletableFuture)this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchIndexMetadataRetrievalFailed(Throwables.expectException((Throwable)e));
        }))).thenApply(list -> {
            if (list.isEmpty()) {
                if (allowNull) {
                    return null;
                }
                throw log.indexMissing(indexNames.getWrite(), indexNames.getRead());
            }
            if (list.size() > 1) {
                throw log.elasticsearchIndexNameAndAliasesMatchMultipleIndexes(indexNames.getWrite(), indexNames.getRead(), list.stream().map(ExistingIndexMetadata::getPrimaryName).collect(Collectors.toSet()));
            }
            return (ExistingIndexMetadata)list.get(0);
        });
    }

    public CompletableFuture<?> putAliases(URLEncodedString indexName, Map<String, IndexAliasDefinition> aliases) {
        Object work = this.getWorkFactory().putIndexAliases(indexName, aliases).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchSettingsUpdateFailed(indexName.original, Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> updateSettings(URLEncodedString indexName, IndexSettings settings) {
        Object work = this.getWorkFactory().putIndexSettings(indexName, settings).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchSettingsUpdateFailed(indexName.original, Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> putMapping(URLEncodedString indexName, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().putIndexTypeMapping(indexName, mapping).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.elasticsearchMappingCreationFailed(indexName.original, e.getMessage(), Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> waitForIndexStatus(IndexNames indexNames, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        IndexStatus requiredIndexStatus = executionOptions.getRequiredStatus();
        String timeoutAndUnit = executionOptions.getRequiredStatusTimeoutInMs() + "ms";
        URLEncodedString alias = indexNames.getWrite();
        Object work = this.getWorkFactory().waitForIndexStatusWork(alias, requiredIndexStatus, timeoutAndUnit).build();
        return this.execute((ElasticsearchWork)work).exceptionally(Futures.handler(e -> {
            throw log.unexpectedIndexStatus(alias, requiredIndexStatus.getElasticsearchString(), timeoutAndUnit, Throwables.expectException((Throwable)e));
        }));
    }

    public CompletableFuture<?> dropIndexIfExisting(URLEncodedString indexName) {
        Object work = this.getWorkFactory().dropIndex(indexName).ignoreIndexNotFound().build();
        return this.execute((ElasticsearchWork)work);
    }

    public CompletableFuture<?> closeIndex(URLEncodedString indexName) {
        Object work = this.getWorkFactory().closeIndex(indexName).build();
        return this.execute((ElasticsearchWork)work).thenRun(() -> log.closedIndex(indexName));
    }

    public CompletableFuture<?> openIndex(URLEncodedString indexName) {
        Object work = this.getWorkFactory().openIndex(indexName).build();
        return this.execute((ElasticsearchWork)work).thenRun(() -> log.openedIndex(indexName));
    }

    private ElasticsearchWorkBuilderFactory getWorkFactory() {
        return this.workBuilderFactory;
    }

    private <T> CompletableFuture<T> execute(ElasticsearchWork<T> work) {
        return this.orchestrator.submit(work);
    }
}

