/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexSettings;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.index.IndexLifecycleStrategyName;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexScopeBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.index.management.impl.ElasticsearchIndexLifecycleStrategy;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexManagerImpl
implements IndexManagerImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchIndexManager,
WorkExecutionIndexManagerContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<IndexLifecycleStrategyName> LIFECYCLE_STRATEGY = ConfigurationProperty.forKey((String)"lifecycle.strategy").as(IndexLifecycleStrategyName.class, IndexLifecycleStrategyName::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_STRATEGY).build();
    private static final ConfigurationProperty<IndexStatus> LIFECYCLE_MINIMAL_REQUIRED_STATUS = ConfigurationProperty.forKey((String)"lifecycle.minimal_required_status").as(IndexStatus.class, IndexStatus::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_MINIMAL_REQUIRED_STATUS).build();
    private static final ConfigurationProperty<Integer> LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT = ConfigurationProperty.forKey((String)"lifecycle.minimal_required_status_wait_timeout").asInteger().withDefault((Object)10000).build();
    private final IndexManagerBackendContext backendContext;
    private final ElasticsearchIndexModel model;
    private final List<DocumentMetadataContributor> documentMetadataContributors;
    private final ElasticsearchWorkOrchestratorImplementor serialOrchestrator;
    private final ElasticsearchWorkOrchestratorImplementor parallelOrchestrator;
    private ElasticsearchIndexAdministrationClient administrationClient;
    private ElasticsearchIndexLifecycleStrategy lifecycleStrategy;

    ElasticsearchIndexManagerImpl(IndexManagerBackendContext backendContext, ElasticsearchIndexModel model, List<DocumentMetadataContributor> documentMetadataContributors) {
        this.backendContext = backendContext;
        this.model = model;
        this.documentMetadataContributors = documentMetadataContributors;
        this.parallelOrchestrator = backendContext.createParallelOrchestrator(model.getHibernateSearchIndexName());
        this.serialOrchestrator = backendContext.createSerialOrchestrator(model.getHibernateSearchIndexName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "names=" + this.model.getNames() + "]";
    }

    public CompletableFuture<?> start(IndexManagerStartContext context) {
        try {
            this.administrationClient = this.backendContext.createAdministrationClient(this.model);
            this.lifecycleStrategy = this.createLifecycleStrategy(context.getConfigurationPropertySource());
            this.serialOrchestrator.start();
            this.parallelOrchestrator.start();
            return this.lifecycleStrategy.onStart(this.administrationClient, context);
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(ElasticsearchWorkOrchestratorImplementor::stop, (Object)this.parallelOrchestrator)).push(ElasticsearchWorkOrchestratorImplementor::stop, (Object)this.serialOrchestrator);
            throw e;
        }
    }

    public CompletableFuture<?> preStop() {
        return CompletableFuture.allOf(this.serialOrchestrator.preStop(), this.parallelOrchestrator.preStop());
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestratorImplementor::stop, (Object)this.serialOrchestrator);
            closer.push(ElasticsearchWorkOrchestratorImplementor::stop, (Object)this.parallelOrchestrator);
            closer.push(strategy -> strategy.onStop(this.administrationClient), (Object)this.lifecycleStrategy);
            this.lifecycleStrategy = null;
            this.administrationClient = null;
        }
        catch (IOException e) {
            throw log.failedToShutdownIndexManager(this.model.getHibernateSearchIndexName(), e, this.backendContext.getEventContext());
        }
    }

    @Override
    public String getMappedTypeName() {
        return this.model.getMappedTypeName();
    }

    @Override
    public URLEncodedString getElasticsearchIndexWriteName() {
        return this.model.getNames().getWrite();
    }

    @Override
    public String toElasticsearchId(String tenantId, String id) {
        return this.backendContext.toElasticsearchId(tenantId, id);
    }

    @Override
    public JsonObject createDocument(String tenantId, String id, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        ElasticsearchDocumentObjectBuilder builder = new ElasticsearchDocumentObjectBuilder();
        documentContributor.contribute((Object)builder);
        JsonObject document = builder.build();
        for (DocumentMetadataContributor contributor : this.documentMetadataContributors) {
            contributor.contribute(document, tenantId, id);
        }
        return document;
    }

    public ElasticsearchIndexModel getModel() {
        return this.model;
    }

    public IndexIndexingPlan<ElasticsearchDocumentObjectBuilder> createIndexingPlan(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.backendContext.createIndexingPlan(this.serialOrchestrator, this, refreshStrategy, sessionContext);
    }

    public IndexIndexer<ElasticsearchDocumentObjectBuilder> createIndexer(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy) {
        return this.backendContext.createIndexer(this.parallelOrchestrator, this, sessionContext);
    }

    public IndexWorkspace createWorkspace(DetachedBackendSessionContext sessionContext) {
        return this.backendContext.createWorkspace(this.parallelOrchestrator, this, sessionContext);
    }

    public IndexScopeBuilder createScopeBuilder(BackendMappingContext mappingContext) {
        return new ElasticsearchIndexScopeBuilder(this.backendContext, mappingContext, this);
    }

    public void addTo(IndexScopeBuilder builder) {
        if (!(builder instanceof ElasticsearchIndexScopeBuilder)) {
            throw log.cannotMixElasticsearchScopeWithOtherType(builder, this, this.backendContext.getEventContext());
        }
        ElasticsearchIndexScopeBuilder esBuilder = (ElasticsearchIndexScopeBuilder)builder;
        esBuilder.add(this.backendContext, this);
    }

    public IndexManager toAPI() {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, ElasticsearchIndexManager.class, this.getBackendAndIndexEventContext());
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.backendContext.getEventContext().append(EventContexts.fromIndexName((String)this.model.getHibernateSearchIndexName()));
    }

    private ElasticsearchIndexLifecycleStrategy createLifecycleStrategy(ConfigurationPropertySource propertySource) {
        return new ElasticsearchIndexLifecycleStrategy((IndexLifecycleStrategyName)((Object)LIFECYCLE_STRATEGY.get(propertySource)), new ElasticsearchIndexLifecycleExecutionOptions((IndexStatus)((Object)LIFECYCLE_MINIMAL_REQUIRED_STATUS.get(propertySource)), (Integer)LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT.get(propertySource)));
    }
}

