/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.management.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.index.IndexLifecycleStrategyName;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;

public class ElasticsearchIndexLifecycleStrategy {
    private final IndexLifecycleStrategyName strategyName;
    protected final ElasticsearchIndexLifecycleExecutionOptions executionOptions;

    public ElasticsearchIndexLifecycleStrategy(IndexLifecycleStrategyName strategyName, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        this.strategyName = strategyName;
        this.executionOptions = executionOptions;
    }

    public CompletableFuture<?> onStart(ElasticsearchIndexAdministrationClient client, IndexManagerStartContext context) {
        switch (this.strategyName) {
            case CREATE: {
                return client.createIfAbsent(this.executionOptions);
            }
            case DROP_AND_CREATE: 
            case DROP_AND_CREATE_AND_DROP: {
                return client.dropAndCreate(this.executionOptions);
            }
            case UPDATE: {
                return client.update(this.executionOptions);
            }
            case VALIDATE: {
                return client.validate(this.executionOptions, context.getFailureCollector());
            }
            case NONE: {
                return CompletableFuture.completedFuture(null);
            }
        }
        throw new AssertionFailure("Unexpected index management strategy: " + (Object)((Object)this.strategyName));
    }

    public void onStop(ElasticsearchIndexAdministrationClient client) {
        switch (this.strategyName) {
            case DROP_AND_CREATE_AND_DROP: {
                Futures.unwrappedExceptionJoin(client.dropIfExisting(this.executionOptions));
                break;
            }
            case CREATE: 
            case DROP_AND_CREATE: 
            case UPDATE: 
            case VALIDATE: 
            case NONE: {
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected index management strategy: " + (Object)((Object)this.strategyName));
            }
        }
    }
}

