/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String elasticsearchRequestFailed$str() {
        return "HSEARCH400007: Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s";
    }

    @Override
    public final SearchException elasticsearchRequestFailed(ElasticsearchRequest request, ElasticsearchResponse response, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestFailed$str(), new ElasticsearchRequestFormatter(request), new ElasticsearchResponseFormatter(response), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String elasticsearchBulkedRequestFailed$str() {
        return "HSEARCH400008: Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s";
    }

    @Override
    public final SearchException elasticsearchBulkedRequestFailed(JsonObject requestMetadata, JsonObject response, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchBulkedRequestFailed$str(), new ElasticsearchJsonObjectFormatter(requestMetadata), new ElasticsearchJsonObjectFormatter(response), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchRequestTimeout$str() {
        return "HSEARCH400010: Elasticsearch connection time-out; check the cluster status, it should be 'green'";
    }

    @Override
    public final SearchException elasticsearchRequestTimeout() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRequestTimeout$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchMappingCreationFailed$str() {
        return "HSEARCH400020: Could not create mapping for index '%1$s': %2$s";
    }

    @Override
    public final SearchException elasticsearchMappingCreationFailed(String indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchMappingCreationFailed$str(), indexName, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexStatus$str() {
        return "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    }

    @Override
    public final SearchException invalidIndexStatus(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedIndexStatus$str() {
        return "HSEARCH400024: Index '%1$s' failed to reach status '%2$s' after %3$s.";
    }

    @Override
    public final SearchException unexpectedIndexStatus(URLEncodedString indexName, String expected, String timeoutAndUnit, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedIndexStatus$str(), indexName, expected, timeoutAndUnit), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchIndexMetadataRetrievalFailed$str() {
        return "HSEARCH400034: Could not retrieve the index metadata from Elasticsearch";
    }

    @Override
    public final SearchException elasticsearchIndexMetadataRetrievalFailed(Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexMetadataRetrievalFailed$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String schemaUpdateFailed$str() {
        return "HSEARCH400035: Could not update mappings in index '%1$s': %2$s";
    }

    @Override
    public final SearchException schemaUpdateFailed(URLEncodedString indexName, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.schemaUpdateFailed$str(), indexName, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexMissing$str() {
        return "HSEARCH400050: Index aliases [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.";
    }

    @Override
    public final SearchException indexMissing(URLEncodedString write, URLEncodedString read) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexMissing$str(), write, read));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executingElasticsearchQuery(String path, Map<String, String> parameters, String bodyParts) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executingElasticsearchQuery$str(), (Object)path, parameters, (Object)bodyParts);
    }

    protected String executingElasticsearchQuery$str() {
        return "HSEARCH400053: Executing Elasticsearch query on '%s' with parameters '%s': <%s>";
    }

    protected String tokenizerNamingConflict$str() {
        return "HSEARCH400055: Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.";
    }

    @Override
    public final SearchException tokenizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenizerNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String charFilterNamingConflict$str() {
        return "HSEARCH400056: Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.";
    }

    @Override
    public final SearchException charFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.charFilterNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tokenFilterNamingConflict$str() {
        return "HSEARCH400057: Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.";
    }

    @Override
    public final SearchException tokenFilterNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tokenFilterNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchSettingsUpdateFailed$str() {
        return "HSEARCH400067: Could not update settings for index '%1$s'";
    }

    @Override
    public final SearchException elasticsearchSettingsUpdateFailed(Object indexName, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchSettingsUpdateFailed$str(), indexName), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void closedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.closedIndex$str(), indexName);
    }

    protected String closedIndex$str() {
        return "HSEARCH400069: Closed Elasticsearch index '%1$s' automatically.";
    }

    @Override
    public final void openedIndex(Object indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.openedIndex$str(), indexName);
    }

    protected String openedIndex$str() {
        return "HSEARCH400070: Opened Elasticsearch index '%1$s' automatically.";
    }

    @Override
    public final void usingPasswordOverHttp() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingPasswordOverHttp$str(), new Object[0]);
    }

    protected String usingPasswordOverHttp$str() {
        return "HSEARCH400073: Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.";
    }

    protected String analyzerNamingConflict$str() {
        return "HSEARCH400074: Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.";
    }

    @Override
    public final SearchException analyzerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analyzerNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToApplyAnalysisConfiguration$str() {
        return "HSEARCH400075: Error while applying analysis configuration: %1$s";
    }

    @Override
    public final SearchException unableToApplyAnalysisConfiguration(String errorMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToApplyAnalysisConfiguration$str(), errorMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchAnalyzerDefinition$str() {
        return "HSEARCH400076: Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.";
    }

    @Override
    public final SearchException invalidElasticsearchAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchAnalyzerDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchTokenizerDefinition$str() {
        return "HSEARCH400077: Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.";
    }

    @Override
    public final SearchException invalidElasticsearchTokenizerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenizerDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchCharFilterDefinition$str() {
        return "HSEARCH400078: Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.";
    }

    @Override
    public final SearchException invalidElasticsearchCharFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchCharFilterDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchTokenFilterDefinition$str() {
        return "HSEARCH400079: Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.";
    }

    @Override
    public final SearchException invalidElasticsearchTokenFilterDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTokenFilterDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToDetectElasticsearchVersion$str() {
        return "HSEARCH400080: Failed to detect the Elasticsearch version running on the cluster: %s";
    }

    @Override
    public final SearchException failedToDetectElasticsearchVersion(String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToDetectElasticsearchVersion$str(), causeMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedElasticsearchVersion$str() {
        return "HSEARCH400081: An unsupported Elasticsearch version runs on the Elasticsearch cluster: '%s'. Please refer to the documentation to know which versions are supported.";
    }

    @Override
    public final SearchException unsupportedElasticsearchVersion(ElasticsearchVersion version) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedElasticsearchVersion$str(), version));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, int bodyParts, long timeInMs, int responseStatusCode, String responseStatusMessage) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.executedRequest7$str(), new Object[]{method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage});
    }

    protected String executedRequest7$str() {
        return "HSEARCH400082: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'.";
    }

    @Override
    public final void unknownElasticsearchVersion(ElasticsearchVersion version) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownElasticsearchVersion$str(), (Object)version);
    }

    protected String unknownElasticsearchVersion$str() {
        return "HSEARCH400085: Hibernate Search may not work correctly, because an unknown Elasticsearch version runs on the Elasticsearch cluster: '%s'.";
    }

    protected String normalizerNamingConflict$str() {
        return "HSEARCH400086: Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.";
    }

    @Override
    public final SearchException normalizerNamingConflict(String remoteName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.normalizerNamingConflict$str(), remoteName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToParseElasticsearchResponse$str() {
        return "HSEARCH400089: Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.";
    }

    @Override
    public final SearchException failedToParseElasticsearchResponse(int statusCode, String statusPhrase, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToParseElasticsearchResponse$str(), statusCode, statusPhrase), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchResponseIndicatesFailure$str() {
        return "HSEARCH400090: Elasticsearch response indicates a failure.";
    }

    @Override
    public final SearchException elasticsearchResponseIndicatesFailure() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseIndicatesFailure$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executedRequest(String method, String path, Map<String, String> getParameters, int bodyParts, long timeInMs, int responseStatusCode, String responseStatusMessage, String requestBodyParts, String responseBody) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.executedRequest9$str(), new Object[]{method, path, getParameters, bodyParts, timeInMs, responseStatusCode, responseStatusMessage, requestBodyParts, responseBody});
    }

    protected String executedRequest9$str() {
        return "HSEARCH400093: Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>";
    }

    protected String cannotMixElasticsearchScopeWithOtherType$str() {
        return "HSEARCH400502: A multi-index scope cannot include both an Elasticsearch index and another type of index. Base scope was: '%1$s', Elasticsearch index was: '%2$s'";
    }

    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherType(IndexScopeBuilder baseScope, ElasticsearchIndexManager elasticsearchIndex, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchScopeWithOtherType$str(), baseScope, elasticsearchIndex), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchScopeWithOtherBackend$str() {
        return "HSEARCH400503: A multi-index scope cannot span multiple Elasticsearch backends. Base scope was: '%1$s', index from another backend was: '%2$s'";
    }

    @Override
    public final SearchException cannotMixElasticsearchScopeWithOtherBackend(IndexScopeBuilder baseScope, ElasticsearchIndexManager indexFromOtherBackend, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchScopeWithOtherBackend$str(), baseScope, indexFromOtherBackend), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return "HSEARCH400504: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchExtensionOnUnknownType$str() {
        return "HSEARCH400506: The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.";
    }

    @Override
    public final SearchException elasticsearchExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchExtensionOnUnknownType$str(), context));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherPredicates$str() {
        return "HSEARCH400508: An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search scope. Given predicate was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate predicate) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherPredicates$str(), predicate));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonObjectFieldForNestedQuery$str() {
        return "HSEARCH400509: Field '%1$s' is not an object field.";
    }

    @Override
    public final SearchException nonObjectFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonObjectFieldForNestedQuery$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonNestedFieldForNestedQuery$str() {
        return "HSEARCH400510: Object field '%1$s' is not stored as nested.";
    }

    @Override
    public final SearchException nonNestedFieldForNestedQuery(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonNestedFieldForNestedQuery$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchSortWithOtherSorts$str() {
        return "HSEARCH400511: An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search scope. Given sort was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort sort) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchSortWithOtherSorts$str(), sort));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyRequiredButNotSupportedByBackend$str() {
        return "HSEARCH400514: Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.";
    }

    @Override
    public final SearchException multiTenancyRequiredButNotSupportedByBackend(String indexName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButNotSupportedByBackend$str(), indexName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH400516: Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.";
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(String tenantId, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantId), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH400517: Backend has multi-tenancy enabled, but no tenant identifier is provided.";
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clientUnwrappingWithUnkownType$str() {
        return "HSEARCH400518: Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.";
    }

    @Override
    public final SearchException clientUnwrappingWithUnkownType(Class<?> requestedClass, Class<?> actualClass) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.clientUnwrappingWithUnkownType$str(), requestedClass, actualClass));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String backendUnwrappingWithUnknownType$str() {
        return "HSEARCH400519: Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException backendUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexSchemaNodeNameConflict$str() {
        return "HSEARCH400520: The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.";
    }

    @Override
    public final SearchException indexSchemaNodeNameConflict(String name, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexSchemaNodeNameConflict$str(), name), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rangesNotSupportedByGeoPoint$str() {
        return "HSEARCH400523: Range lookups (range predicates, range aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }

    @Override
    public final SearchException rangesNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangesNotSupportedByGeoPoint$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String directValueLookupNotSupportedByGeoPoint$str() {
        return "HSEARCH400524: Direct value lookups (match predicates, terms aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.";
    }

    @Override
    public final SearchException directValueLookupNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.directValueLookupNotSupportedByGeoPoint$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFieldForDocumentElement$str() {
        return "HSEARCH400525: Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.";
    }

    @Override
    public final SearchException invalidFieldForDocumentElement(String expectedPath, String actualPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFieldForDocumentElement$str(), expectedPath, actualPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchResponseMissingData$str() {
        return "HSEARCH400526: Expected data was missing in the Elasticsearch response.";
    }

    @Override
    public final AssertionFailure elasticsearchResponseMissingData() {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.elasticsearchResponseMissingData$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String spatialPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH400527: Spatial predicates are not supported by this field's type.";
    }

    @Override
    public final SearchException spatialPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.spatialPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String distanceOperationsNotSupportedByFieldType$str() {
        return "HSEARCH400528: Distance related operations are not supported by this field's type.";
    }

    @Override
    public final SearchException distanceOperationsNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.distanceOperationsNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String minimumShouldMatchConflictingConstraints$str() {
        return "HSEARCH400529: Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'";
    }

    @Override
    public final SearchException minimumShouldMatchConflictingConstraints(int ceiling) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.minimumShouldMatchConflictingConstraints$str(), ceiling));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingIndexNames$str() {
        return "HSEARCH400530: Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the name or alias '%3$s'";
    }

    @Override
    public final SearchException conflictingIndexNames(String firstHibernateSearchIndexName, String secondHibernateSearchIndexName, String nameOrAlias) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingIndexNames$str(), firstHibernateSearchIndexName, secondHibernateSearchIndexName, nameOrAlias));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchResponseUnknownIndexName$str() {
        return "HSEARCH400531: Could not resolve index name '%1$s' to an entity type: %2$s";
    }

    @Override
    public final SearchException elasticsearchResponseUnknownIndexName(String elasticsearchIndexName, String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchResponseUnknownIndexName$str(), elasticsearchIndexName, causeMessage), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConvertDslParameter$str() {
        return "HSEARCH400532: Unable to convert DSL parameter: %1$s";
    }

    @Override
    public final SearchException cannotConvertDslParameter(String errorMessage, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConvertDslParameter$str(), errorMessage), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexManagerUnwrappingWithUnknownType$str() {
        return "HSEARCH400533: Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.";
    }

    @Override
    public final SearchException indexManagerUnwrappingWithUnknownType(Class<?> requestedClass, Class<?> actualClass, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexManagerUnwrappingWithUnknownType$str(), new ClassFormatter(requestedClass), new ClassFormatter(actualClass)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchTypedAnalyzerDefinition$str() {
        return "HSEARCH400534: Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.";
    }

    @Override
    public final SearchException invalidElasticsearchTypedAnalyzerDefinition(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchTypedAnalyzerDefinition$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotApplyAnalyzerAndNormalizer$str() {
        return "HSEARCH400535: Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.";
    }

    @Override
    public final SearchException cannotApplyAnalyzerAndNormalizer(String analyzerName, String normalizerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotApplyAnalyzerAndNormalizer$str(), analyzerName, normalizerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseAnalyzerOnSortableField$str() {
        return "HSEARCH400536: Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnSortableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnSortableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String analysisComponentParameterConflict$str() {
        return "HSEARCH400537: Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'";
    }

    @Override
    public final SearchException analysisComponentParameterConflict(String name, JsonElement value1, JsonElement value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.analysisComponentParameterConflict$str(), name, value1, value2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherProjections$str() {
        return "HSEARCH400538: An Elasticsearch query cannot include search projections built using a non-Elasticsearch search scope. Given projection was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> projection) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherProjections$str(), projection));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidProjectionInvalidType$str() {
        return "HSEARCH400539: Invalid type '%2$s' for projection on field '%1$s'.";
    }

    @Override
    public final SearchException invalidProjectionInvalidType(String absoluteFieldPath, Class<?> type, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidProjectionInvalidType$str(), absoluteFieldPath, new ClassFormatter(type)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String traditionalSortNotSupportedByGeoPoint$str() {
        return "HSEARCH400540: Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.";
    }

    @Override
    public final SearchException traditionalSortNotSupportedByGeoPoint(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.traditionalSortNotSupportedByGeoPoint$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingFieldTypesForPredicate$str() {
        return "HSEARCH400541: Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForPredicate(String absoluteFieldPath, ElasticsearchFieldPredicateBuilderFactory component1, ElasticsearchFieldPredicateBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForPredicate$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingFieldTypesForSort$str() {
        return "HSEARCH400542: Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForSort(String absoluteFieldPath, ElasticsearchFieldSortBuilderFactory component1, ElasticsearchFieldSortBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForSort$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingFieldTypesForProjection$str() {
        return "HSEARCH400543: Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForProjection(String absoluteFieldPath, ElasticsearchFieldProjectionBuilderFactory component1, ElasticsearchFieldProjectionBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForProjection$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToShutdownBackend$str() {
        return "HSEARCH400544: Failed to shut down the Elasticsearch backend.";
    }

    @Override
    public final SearchException failedToShutdownBackend(Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownBackend$str(), new Object[0]), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotGuessFieldType$str() {
        return "HSEARCH400545: Cannot guess field type for input type %1$s.";
    }

    @Override
    public final SearchException cannotGuessFieldType(Class<?> inputType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotGuessFieldType$str(), new ClassFormatter(inputType)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonProjectableField$str() {
        return "HSEARCH400547: Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.";
    }

    @Override
    public final SearchException nonProjectableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonProjectableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsortableField$str() {
        return "HSEARCH400548: Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.";
    }

    @Override
    public final SearchException unsortableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsortableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingIdentifierTypesForPredicate$str() {
        return "HSEARCH400549: Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.";
    }

    @Override
    public final SearchException conflictingIdentifierTypesForPredicate(ToDocumentIdentifierValueConverter<?> component1, ToDocumentIdentifierValueConverter<?> component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingIdentifierTypesForPredicate$str(), component1, component2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToShutdownIndexManager$str() {
        return "HSEARCH400550: Failed to shut down the Elasticsearch index manager with name '%1$s'.";
    }

    @Override
    public final SearchException failedToShutdownIndexManager(String indexName, Exception cause, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToShutdownIndexManager$str(), indexName), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchSkippedBecauseOfPreviousWork$str() {
        return "HSEARCH400551: The operation was skipped due to the failure of a previous work in the same workset.";
    }

    @Override
    public final SearchException elasticsearchSkippedBecauseOfPreviousWork(Throwable skippingCause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchSkippedBecauseOfPreviousWork$str(), new Object[0]), skippingCause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexLifecycleStrategyName$str() {
        return "HSEARCH400552: Invalid index lifecycle strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidIndexLifecycleStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexLifecycleStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String textPredicatesNotSupportedByFieldType$str() {
        return "HSEARCH400553: Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.";
    }

    @Override
    public final SearchException textPredicatesNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.textPredicatesNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompleteFieldDefinition$str() {
        return "HSEARCH400554: Incomplete field definition. You must call toReference() to complete the field definition.";
    }

    @Override
    public final SearchException incompleteFieldDefinition(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompleteFieldDefinition$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateReferenceMultipleTimes$str() {
        return "HSEARCH400555: Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.";
    }

    @Override
    public final SearchException cannotCreateReferenceMultipleTimes(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateReferenceMultipleTimes$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidElasticsearchVersion$str() {
        return "HSEARCH400556: Invalid Elasticsearch version: '%1$s'. The version must be in the form 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.";
    }

    @Override
    public final SearchException invalidElasticsearchVersion(String versionString) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchVersion$str(), versionString));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedElasticsearchVersion$str() {
        return "HSEARCH400559: Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.";
    }

    @Override
    public final SearchException unexpectedElasticsearchVersion(ElasticsearchVersion configuredVersion, ElasticsearchVersion actualVersion) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedElasticsearchVersion$str(), configuredVersion, actualVersion));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String skipAnalysisOnKeywordField$str() {
        return "HSEARCH400560: Elasticsearch backend does not support skip analysis on not analyzed field: '%1$s'.";
    }

    @Override
    public final SearchException skipAnalysisOnKeywordField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.skipAnalysisOnKeywordField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousElasticsearchVersion$str() {
        return "HSEARCH400561: Ambiguous Elasticsearch version: '%s'. This version matches multiple dialects. Please use a more precise version to remove the ambiguity.";
    }

    @Override
    public final SearchException ambiguousElasticsearchVersion(ElasticsearchVersion version) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.ambiguousElasticsearchVersion$str(), version));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseIndexNullAsAndAnalyzer$str() {
        return "HSEARCH400562: Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.";
    }

    @Override
    public final SearchException cannotUseIndexNullAsAndAnalyzer(String analyzerName, String indexNullAs, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseIndexNullAsAndAnalyzer$str(), analyzerName, indexNullAs), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleValuesForSingleValuedField$str() {
        return "HSEARCH400563: Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.";
    }

    @Override
    public final SearchException multipleValuesForSingleValuedField(String absolutePath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleValuesForSingleValuedField$str(), absolutePath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainRequiresIndexName$str() {
        return "HSEARCH400564: explain(String id) cannot be used when the query targets multiple indexes. Use explain(String indexName, String id) and pass one of %1$s as the index name.";
    }

    @Override
    public final SearchException explainRequiresIndexName(Set<String> targetedIndexNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresIndexName$str(), targetedIndexNames));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainRequiresIndexTargetedByQuery$str() {
        return "HSEARCH400565: The given index name '%2$s' is not among the indexes targeted by this query: %1$s.";
    }

    @Override
    public final SearchException explainRequiresIndexTargetedByQuery(Set<String> targetedIndexNames, String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainRequiresIndexTargetedByQuery$str(), targetedIndexNames, indexName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String explainUnknownDocument$str() {
        return "HSEARCH400566: Document with id '%1$s' does not exist in the targeted index and thus its match cannot be explained.";
    }

    @Override
    public final SearchException explainUnknownDocument(URLEncodedString id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.explainUnknownDocument$str(), id));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(String name, InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.interruptedWhileWaitingForIndexActivity$str(), (Object)name);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return "HSEARCH400567: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    }

    protected String nullDecimalScale$str() {
        return "HSEARCH400568: Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.";
    }

    @Override
    public final SearchException nullDecimalScale(EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nullDecimalScale$str(), new Object[0]), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String scaledNumberTooLarge$str() {
        return "HSEARCH400569: The value '%1$s' cannot be indexed because its absolute value is too large.";
    }

    @Override
    public final SearchException scaledNumberTooLarge(Number value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.scaledNumberTooLarge$str(), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDecimalScale$str() {
        return "HSEARCH400570: Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.";
    }

    @Override
    public final SearchException invalidDecimalScale(Integer decimalScale, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDecimalScale$str(), decimalScale), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonSearchableField$str() {
        return "HSEARCH400571: Field '%1$s' is not searchable. Make sure the field is marked as searchable.";
    }

    @Override
    public final SearchException nonSearchableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonSearchableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String predicateDefinedOnDifferentIndexes$str() {
        return "HSEARCH400572: The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException predicateDefinedOnDifferentIndexes(SearchPredicate predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.predicateDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sortDefinedOnDifferentIndexes$str() {
        return "HSEARCH400573: The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException sortDefinedOnDifferentIndexes(SearchSort predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sortDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String projectionDefinedOnDifferentIndexes$str() {
        return "HSEARCH400574: The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> predicate, Set<String> predicateIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectionDefinedOnDifferentIndexes$str(), predicate, predicateIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingNestedDocumentPathsForProjection$str() {
        return "HSEARCH400575: Multiple conflicting nested document paths to build a projection for field '%1$s'. '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingNestedDocumentPathsForProjection(String absoluteFieldPath, String nestedDocumentPath1, String nestedDocumentPath2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingNestedDocumentPathsForProjection$str(), absoluteFieldPath, nestedDocumentPath1, nestedDocumentPath2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseAnalyzerOnAggregableField$str() {
        return "HSEARCH400576: Cannot apply an analyzer on an aggregable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.";
    }

    @Override
    public final SearchException cannotUseAnalyzerOnAggregableField(String analyzerName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseAnalyzerOnAggregableField$str(), analyzerName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonAggregableField$str() {
        return "HSEARCH400577: Aggregations are not enabled for field '%1$s'. Make sure the field is marked as aggregable.";
    }

    @Override
    public final SearchException nonAggregableField(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonAggregableField$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAggregationInvalidType$str() {
        return "HSEARCH400578: Invalid type '%2$s' for aggregation on field '%1$s'.";
    }

    @Override
    public final SearchException invalidAggregationInvalidType(String absoluteFieldPath, Class<?> type, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAggregationInvalidType$str(), absoluteFieldPath, new ClassFormatter(type)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingFieldTypesForAggregation$str() {
        return "HSEARCH400579: Multiple conflicting types to build an aggregation for field '%1$s': '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingFieldTypesForAggregation(String absoluteFieldPath, ElasticsearchFieldAggregationBuilderFactory component1, ElasticsearchFieldAggregationBuilderFactory component2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldTypesForAggregation$str(), absoluteFieldPath, component1, component2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str() {
        return "HSEARCH400580: Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). The given range is not in canonical form: '%1$s'.";
    }

    @Override
    public final SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(Range<?> range) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchRangeAggregationRequiresCanonicalFormForRanges$str(), range));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotMixElasticsearchSearchQueryWithOtherAggregations$str() {
        return "HSEARCH400581: An Elasticsearch query cannot include search aggregations built using a non-Elasticsearch search scope. Given aggregation was: '%1$s'";
    }

    @Override
    public final SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(SearchAggregation<?> aggregation) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMixElasticsearchSearchQueryWithOtherAggregations$str(), aggregation));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aggregationDefinedOnDifferentIndexes$str() {
        return "HSEARCH400582: The aggregation '%1$s' is defined on a scope targeting different indexes. Aggregation is targeting: '%2$s'. Current scope is targeting: '%3$s'.";
    }

    @Override
    public final SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> aggregation, Set<String> aggregationIndexes, Set<String> scopeIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.aggregationDefinedOnDifferentIndexes$str(), aggregation, aggregationIndexes, scopeIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String termsAggregationsNotSupportedByAnalyzedTextFieldType$str() {
        return "HSEARCH400583: Terms aggregations are not supported by this field's type (string field with analyzed). Use a normalized field instead.";
    }

    @Override
    public final SearchException termsAggregationsNotSupportedByAnalyzedTextFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.termsAggregationsNotSupportedByAnalyzedTextFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String rangeAggregationsNotSupportedByFieldType$str() {
        return "HSEARCH400584: Range aggregations are not supported by this field's type.";
    }

    @Override
    public final SearchException rangeAggregationsNotSupportedByFieldType(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangeAggregationsNotSupportedByFieldType$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateAggregationKey$str() {
        return "HSEARCH400585: Multiple aggregations with the same key: '%1$s'";
    }

    @Override
    public final SearchException duplicateAggregationKey(AggregationKey key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.duplicateAggregationKey$str(), new AggregationKeyFormatter(key)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingNestedDocumentPathHierarchyForProjection$str() {
        return "HSEARCH400586: Multiple conflicting nested document paths to build a projection for field '%1$s'. '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException conflictingNestedDocumentPathHierarchyForProjection(String absoluteFieldPath, List<String> nestedDocumentPathHierarchy1, List<String> nestedDocumentPathHierarchy2, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingNestedDocumentPathHierarchyForProjection$str(), absoluteFieldPath, nestedDocumentPathHierarchy1, nestedDocumentPathHierarchy2), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String searchAnalyzerWithoutAnalyzer$str() {
        return "HSEARCH400587: Cannot apply a search analyzer if an analyzer has not been defined on the same field. Search analyzer: '%1$s'.";
    }

    @Override
    public final SearchException searchAnalyzerWithoutAnalyzer(String searchAnalyzer, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchAnalyzerWithoutAnalyzer$str(), searchAnalyzer), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchFailedBecauseOfBulkFailure$str() {
        return "HSEARCH400588: The operation failed due to the failure of the call to the bulk REST API.";
    }

    @Override
    public final SearchException elasticsearchFailedBecauseOfBulkFailure(Throwable bulkFailure) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchFailedBecauseOfBulkFailure$str(), new Object[0]), bulkFailure);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidHostAndPort$str() {
        return "HSEARCH400589: Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.";
    }

    @Override
    public final SearchException invalidHostAndPort(String hostAndPort, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidHostAndPort$str(), hostAndPort), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timedOut$str() {
        return "HSEARCH400590: Request exceeded the timeout of %1$s: '%2$s'.";
    }

    @Override
    public final SearchTimeoutException timedOut(Duration timeout, ElasticsearchRequest request) {
        SearchTimeoutException result = new SearchTimeoutException(String.format(this.getLoggingLocale(), this.timedOut$str(), new DurationInSecondsAndFractionsFormatter(timeout), new ElasticsearchRequestFormatter(request)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidTypeNameMappingStrategyName$str() {
        return "HSEARCH400591: Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidTypeNameMappingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTypeNameMappingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingTypeFieldInDocument$str() {
        return "HSEARCH400592: Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.";
    }

    @Override
    public final SearchException missingTypeFieldInDocument(String fieldName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingTypeFieldInDocument$str(), fieldName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str() {
        return "HSEARCH400593: Index aliases [%1$s, %2$s] are assigned to a single Hibernate Search index,  but they are already defined in Elasticsearch and point to multiple distinct indexes: %3$s.";
    }

    @Override
    public final SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(URLEncodedString write, URLEncodedString read, Set<String> matchingIndexes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.elasticsearchIndexNameAndAliasesMatchMultipleIndexes$str(), write, read, matchingIndexes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexPrimaryName$str() {
        return "HSEARCH400594: Index primary name  '%1$s' does not match the expected pattern '%2$s'.";
    }

    @Override
    public final SearchException invalidIndexPrimaryName(String elasticsearchIndexName, Pattern pattern) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexPrimaryName$str(), elasticsearchIndexName, pattern));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexUniqueKey$str() {
        return "HSEARCH400595: Unique key '%1$s' extracted from the index name does not match any of %2$s";
    }

    @Override
    public final SearchException invalidIndexUniqueKey(String uniqueKey, Set<String> knownKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexUniqueKey$str(), uniqueKey, knownKeys));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sameWriteAndReadAliases$str() {
        return "HSEARCH400596: Write alias and read alias must be different, but were set to the same value: '%1$s'.";
    }

    @Override
    public final SearchException sameWriteAndReadAliases(URLEncodedString writeAndReadAlias, EventContext eventContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.sameWriteAndReadAliases$str(), writeAndReadAlias), eventContext);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

