/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkAggregator;

class ElasticsearchSerialWorkProcessor
implements ElasticsearchWorkProcessor {
    private final BulkAndSequenceAggregator aggregator;
    private CompletableFuture<Void> future = CompletableFuture.completedFuture(null);

    public ElasticsearchSerialWorkProcessor(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
        this.aggregator = new BulkAndSequenceAggregator(sequenceBuilder, bulker);
    }

    public void beginBatch() {
        this.aggregator.reset();
    }

    @Override
    public void beforeWorkSet() {
        this.aggregator.initSequence(this.future);
    }

    @Override
    public <T> CompletableFuture<T> submit(ElasticsearchWork<T> work) {
        return work.aggregate(this.aggregator);
    }

    @Override
    public CompletableFuture<Void> afterWorkSet() {
        CompletableFuture<Void> sequenceFuture = this.aggregator.buildSequence();
        this.future = sequenceFuture.exceptionally(e -> null);
        return sequenceFuture;
    }

    public CompletableFuture<Void> endBatch() {
        this.aggregator.finalizeBulkWork();
        return this.future;
    }

    public long completeOrDelay() {
        return 0L;
    }

    private static class BulkAndSequenceAggregator
    implements ElasticsearchWorkAggregator {
        private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
        private final ElasticsearchWorkBulker bulker;

        public BulkAndSequenceAggregator(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
            this.sequenceBuilder = sequenceBuilder;
            this.bulker = bulker;
        }

        public void initSequence(CompletableFuture<?> previous) {
            this.sequenceBuilder.init(previous);
        }

        @Override
        public <T> CompletableFuture<T> addBulkable(BulkableElasticsearchWork<T> work) {
            return this.bulker.add(work);
        }

        @Override
        public <T> CompletableFuture<T> addNonBulkable(ElasticsearchWork<T> work) {
            if (this.bulker.addWorksToSequence()) {
                this.bulker.finalizeBulkWork();
            }
            return this.sequenceBuilder.addNonBulkExecution(work);
        }

        public CompletableFuture<Void> buildSequence() {
            this.bulker.addWorksToSequence();
            return this.sequenceBuilder.build();
        }

        public void finalizeBulkWork() {
            this.bulker.finalizeBulkWork();
        }

        public void reset() {
            this.bulker.reset();
        }
    }
}

