/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSet;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.util.common.impl.Futures;

class ElasticsearchSingleWorkSet<T>
implements ElasticsearchWorkSet {
    private final ElasticsearchWork<T> work;
    private final CompletableFuture<T> future;

    ElasticsearchSingleWorkSet(ElasticsearchWork<T> work, CompletableFuture<T> future) {
        this.work = work;
        this.future = future;
    }

    public void submitTo(ElasticsearchWorkProcessor delegate) {
        delegate.beforeWorkSet();
        delegate.submit(this.work).whenComplete(Futures.copyHandler(this.future));
        delegate.afterWorkSet();
    }

    public void markAsFailed(Throwable t) {
        this.future.completeExceptionally(t);
    }
}

