/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexFieldComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchSucceedingCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;

public class ElasticsearchSimpleQueryStringPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements SimpleQueryStringPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor SIMPLE_QUERY_STRING_ACCESSOR = JsonAccessor.root().property("simple_query_string").asObject();
    private static final JsonAccessor<String> QUERY_ACCESSOR = JsonAccessor.root().property("query").asString();
    private static final JsonAccessor<JsonElement> DEFAULT_OPERATOR_ACCESSOR = JsonAccessor.root().property("default_operator");
    private static final JsonAccessor<JsonArray> FIELDS_ACCESSOR = JsonAccessor.root().property("fields").asArray();
    private static final JsonAccessor<String> ANALYZER_ACCESSOR = JsonAccessor.root().property("analyzer").asString();
    private static final JsonPrimitive AND_OPERATOR_KEYWORD_JSON = new JsonPrimitive("and");
    private static final JsonPrimitive OR_OPERATOR_KEYWORD_JSON = new JsonPrimitive("or");
    private final ElasticsearchScopeModel scopeModel;
    private final Map<String, ElasticsearchSimpleQueryStringPredicateBuilderFieldState> fields = new LinkedHashMap<String, ElasticsearchSimpleQueryStringPredicateBuilderFieldState>();
    private JsonPrimitive defaultOperator = OR_OPERATOR_KEYWORD_JSON;
    private String simpleQueryString;
    private String analyzer;
    private ElasticsearchCompatibilityChecker analyzerChecker = new ElasticsearchSucceedingCompatibilityChecker();

    ElasticsearchSimpleQueryStringPredicateBuilder(ElasticsearchScopeModel scopeModel) {
        this.scopeModel = scopeModel;
    }

    public void defaultOperator(BooleanOperator operator) {
        switch (operator) {
            case AND: {
                this.defaultOperator = AND_OPERATOR_KEYWORD_JSON;
                break;
            }
            case OR: {
                this.defaultOperator = OR_OPERATOR_KEYWORD_JSON;
            }
        }
    }

    public SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
        ElasticsearchSimpleQueryStringPredicateBuilderFieldState field = this.fields.get(absoluteFieldPath);
        if (field == null) {
            ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, ElasticsearchSearchPredicateBuilderFactoryImpl.PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
            field = fieldComponent.getComponent().createSimpleQueryStringFieldContext(absoluteFieldPath);
            this.analyzerChecker = this.analyzerChecker.combine(fieldComponent.getAnalyzerCompatibilityChecker());
            this.fields.put(absoluteFieldPath, field);
        }
        return field;
    }

    public void simpleQueryString(String simpleQueryString) {
        this.simpleQueryString = simpleQueryString;
    }

    public void analyzer(String analyzerName) {
        this.analyzer = analyzerName;
    }

    public void skipAnalysis() {
        this.analyzer("keyword");
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        if (this.analyzer == null) {
            this.analyzerChecker.failIfNotCompatible();
        }
        QUERY_ACCESSOR.set(innerObject, this.simpleQueryString);
        DEFAULT_OPERATOR_ACCESSOR.set(innerObject, (JsonElement)this.defaultOperator);
        JsonArray fieldArray = new JsonArray();
        for (ElasticsearchSimpleQueryStringPredicateBuilderFieldState fieldContext : this.fields.values()) {
            fieldArray.add((JsonElement)fieldContext.build());
        }
        FIELDS_ACCESSOR.set(innerObject, fieldArray);
        if (this.analyzer != null) {
            ANALYZER_ACCESSOR.set(innerObject, this.analyzer);
        }
        SIMPLE_QUERY_STRING_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }
}

