/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class ElasticsearchExplanationProjection
implements ElasticsearchSearchProjection<JsonObject, JsonObject> {
    private static final JsonAccessor<Boolean> REQUEST_EXPLAIN_ACCESSOR = JsonAccessor.root().property("explain").asBoolean();
    private static final JsonObjectAccessor HIT_EXPLANATION_ACCESSOR = JsonAccessor.root().property("_explanation").asObject();
    private final Set<String> indexNames;

    ElasticsearchExplanationProjection(Set<String> indexNames) {
        this.indexNames = indexNames;
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        REQUEST_EXPLAIN_ACCESSOR.set(requestBody, true);
    }

    @Override
    public JsonObject extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject hit, SearchProjectionExtractContext context) {
        return (JsonObject)HIT_EXPLANATION_ACCESSOR.get(hit).get();
    }

    @Override
    public JsonObject transform(LoadingResult<?> loadingResult, JsonObject extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

