/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryExtractContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultImpl;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;

public class ElasticsearchLoadableSearchResult<H> {
    private final ElasticsearchSearchQueryExtractContext extractContext;
    private final ElasticsearchSearchProjection<?, H> rootProjection;
    private final long hitCount;
    private List<Object> extractedHits;
    private final Map<AggregationKey<?>, ?> extractedAggregations;
    private final Integer took;
    private final Boolean timedOut;

    ElasticsearchLoadableSearchResult(ElasticsearchSearchQueryExtractContext extractContext, ElasticsearchSearchProjection<?, H> rootProjection, long hitCount, List<Object> extractedHits, Map<AggregationKey<?>, ?> extractedAggregations, Integer took, Boolean timedOut) {
        this.extractContext = extractContext;
        this.rootProjection = rootProjection;
        this.hitCount = hitCount;
        this.extractedHits = extractedHits;
        this.extractedAggregations = extractedAggregations;
        this.took = took;
        this.timedOut = timedOut;
    }

    ElasticsearchSearchResult<H> loadBlocking() {
        int readIndex;
        SearchProjectionTransformContext transformContext = this.extractContext.createProjectionTransformContext();
        LoadingResult loadingResult = this.extractContext.getProjectionHitMapper().loadBlocking();
        int writeIndex = 0;
        for (readIndex = 0; readIndex < this.extractedHits.size(); ++readIndex) {
            transformContext.reset();
            H transformed = ElasticsearchSearchProjection.transformUnsafe(this.rootProjection, loadingResult, this.extractedHits.get(readIndex), transformContext);
            if (transformContext.hasFailedLoad()) continue;
            this.extractedHits.set(writeIndex, transformed);
            ++writeIndex;
        }
        if (writeIndex < readIndex) {
            this.extractedHits.subList(writeIndex, readIndex).clear();
        }
        List<Object> loadedHits = Collections.unmodifiableList(this.extractedHits);
        this.extractedHits = null;
        return new ElasticsearchSearchResultImpl<Object>(this.extractContext.getResponseBody(), this.hitCount, loadedHits, this.extractedAggregations, this.took, this.timedOut);
    }
}

