/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DistanceSortKey;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformer;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryRequestContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchQueryBuilder<H>
implements SearchQueryBuilder<H, ElasticsearchSearchQueryElementCollector>,
ElasticsearchSearchQueryElementCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final ElasticsearchSearchContext searchContext;
    private final BackendSessionContext sessionContext;
    private final ElasticsearchSearchPredicateContext rootPredicateContext;
    private final LoadingContextBuilder<?, ?, ?> loadingContextBuilder;
    private final ElasticsearchSearchProjection<?, H> rootProjection;
    private final Set<String> routingKeys;
    private JsonObject jsonPredicate;
    private JsonArray jsonSort;
    private Map<DistanceSortKey, Integer> distanceSorts;
    private Map<AggregationKey<?>, ElasticsearchSearchAggregation<?>> aggregations;
    private Long timeoutValue;
    private TimeUnit timeoutUnit;
    private boolean exceptionOnTimeout;
    private ElasticsearchSearchRequestTransformer requestTransformer;

    public ElasticsearchSearchQueryBuilder(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory, ElasticsearchWorkOrchestrator queryOrchestrator, ElasticsearchSearchContext searchContext, BackendSessionContext sessionContext, LoadingContextBuilder<?, ?, ?> loadingContextBuilder, ElasticsearchSearchProjection<?, H> rootProjection) {
        this.workFactory = workFactory;
        this.searchResultExtractorFactory = searchResultExtractorFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.rootPredicateContext = new ElasticsearchSearchPredicateContext(sessionContext);
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
    }

    public ElasticsearchSearchQueryElementCollector toQueryElementCollector() {
        return this;
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    public void truncateAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.exceptionOnTimeout = false;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutValue = timeout;
        this.timeoutUnit = timeUnit;
        this.exceptionOnTimeout = true;
    }

    @Override
    public ElasticsearchSearchPredicateContext getRootPredicateContext() {
        return this.rootPredicateContext;
    }

    @Override
    public void collectPredicate(JsonObject jsonQuery) {
        this.jsonPredicate = jsonQuery;
    }

    @Override
    public void collectSort(JsonElement sort) {
        if (this.jsonSort == null) {
            this.jsonSort = new JsonArray();
        }
        this.jsonSort.add(sort);
    }

    @Override
    public void collectDistanceSort(JsonElement sort, String absoluteFieldPath, GeoPoint center) {
        this.collectSort(sort);
        int index = this.jsonSort.size() - 1;
        if (this.distanceSorts == null) {
            this.distanceSorts = CollectionHelper.newHashMap((int)3);
        }
        this.distanceSorts.put(new DistanceSortKey(absoluteFieldPath, center), index);
    }

    @Override
    public <A> void collectAggregation(AggregationKey<A> key, ElasticsearchSearchAggregation<A> aggregation) {
        ElasticsearchSearchAggregation<A> previous;
        if (this.aggregations == null) {
            this.aggregations = new LinkedHashMap();
        }
        if ((previous = this.aggregations.put(key, aggregation)) != null) {
            throw log.duplicateAggregationKey(key);
        }
    }

    public void requestTransformer(ElasticsearchSearchRequestTransformer transformer) {
        Contracts.assertNotNull((Object)transformer, (String)"transformer");
        this.requestTransformer = transformer;
    }

    public ElasticsearchSearchQuery<H> build() {
        JsonObject jsonQuery;
        JsonObject payload = new JsonObject();
        JsonArray filters = new JsonArray();
        JsonObject filter = this.searchContext.getFilterOrNull(this.sessionContext.getTenantIdentifier());
        if (filter != null) {
            filters.add((JsonElement)filter);
        }
        if (!this.routingKeys.isEmpty()) {
            filters.add((JsonElement)Queries.anyTerm("_routing", this.routingKeys));
        }
        if ((jsonQuery = Queries.boolFilter(this.jsonPredicate, filters)) != null) {
            payload.add("query", (JsonElement)jsonQuery);
        }
        if (this.jsonSort != null) {
            payload.add("sort", (JsonElement)this.jsonSort);
        }
        LoadingContext loadingContext = this.loadingContextBuilder.build();
        ElasticsearchSearchQueryRequestContext requestContext = new ElasticsearchSearchQueryRequestContext(this.searchContext, this.sessionContext, loadingContext, this.distanceSorts);
        this.rootProjection.request(payload, requestContext);
        if (this.aggregations != null) {
            JsonObject jsonAggregations = new JsonObject();
            for (Map.Entry<AggregationKey<?>, ElasticsearchSearchAggregation<?>> entry : this.aggregations.entrySet()) {
                jsonAggregations.add(entry.getKey().getName(), (JsonElement)entry.getValue().request(requestContext));
            }
            payload.add("aggregations", (JsonElement)jsonAggregations);
        }
        ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor = this.searchResultExtractorFactory.createResultExtractor(requestContext, this.rootProjection, this.aggregations == null ? Collections.emptyMap() : this.aggregations);
        return new ElasticsearchSearchQueryImpl<H>(this.workFactory, this.queryOrchestrator, this.searchContext, this.sessionContext, loadingContext, this.routingKeys, payload, this.requestTransformer, searchResultExtractor, this.timeoutValue, this.timeoutUnit, this.exceptionOnTimeout);
    }
}

