/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DistanceSortKey;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryExtractContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.spatial.GeoPoint;

class ElasticsearchSearchQueryRequestContext
implements SearchProjectionRequestContext,
AggregationRequestContext {
    private final ElasticsearchSearchContext searchContext;
    private final BackendSessionContext sessionContext;
    private final LoadingContext<?, ?> loadingContext;
    private final Map<DistanceSortKey, Integer> distanceSorts;

    ElasticsearchSearchQueryRequestContext(ElasticsearchSearchContext searchContext, BackendSessionContext sessionContext, LoadingContext<?, ?> loadingContext, Map<DistanceSortKey, Integer> distanceSorts) {
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.distanceSorts = distanceSorts != null ? Collections.unmodifiableMap(distanceSorts) : null;
    }

    @Override
    public Integer getDistanceSortIndex(String absoluteFieldPath, GeoPoint location) {
        if (this.distanceSorts == null) {
            return null;
        }
        return this.distanceSorts.get(new DistanceSortKey(absoluteFieldPath, location));
    }

    @Override
    public ElasticsearchSearchSyntax getSearchSyntax() {
        return this.searchContext.getSearchSyntax();
    }

    ElasticsearchSearchQueryExtractContext createExtractContext(JsonObject responseBody) {
        return new ElasticsearchSearchQueryExtractContext(this, this.sessionContext, this.loadingContext.getProjectionHitMapper(), responseBody);
    }
}

