/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSearchSortBuilder;

public abstract class AbstractElasticsearchSearchNestedSortBuilder
extends AbstractElasticsearchSearchSortBuilder {
    private static final JsonAccessor<JsonElement> NESTED_ACCESSOR = JsonAccessor.root().property("nested");
    private static final JsonAccessor<JsonElement> PATH_ACCESSOR = JsonAccessor.root().property("path");
    private static final JsonAccessor<JsonElement> NESTED_PATH_ACCESSOR = JsonAccessor.root().property("nested_path");
    private final List<String> nestedPathHierarchy;
    private final ElasticsearchSearchSyntax searchSyntax;

    public AbstractElasticsearchSearchNestedSortBuilder(List<String> nestedPathHierarchy, ElasticsearchSearchSyntax searchSyntax) {
        this.nestedPathHierarchy = nestedPathHierarchy;
        this.searchSyntax = searchSyntax;
    }

    @Override
    protected void enrichInnerObject(JsonObject innerObject) {
        if (this.nestedPathHierarchy.isEmpty()) {
            return;
        }
        if (this.searchSyntax.useOldSortNestedApi()) {
            String lastNestedPath = this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
            NESTED_PATH_ACCESSOR.set(innerObject, (JsonElement)new JsonPrimitive(lastNestedPath));
            return;
        }
        JsonObject nextNestedObjectTarget = innerObject;
        for (String nestedPath : this.nestedPathHierarchy) {
            JsonObject nestedObject = new JsonObject();
            PATH_ACCESSOR.set(nestedObject, (JsonElement)new JsonPrimitive(nestedPath));
            NESTED_ACCESSOR.set(nextNestedObjectTarget, (JsonElement)nestedObject);
            nextNestedObjectTarget = nestedObject;
        }
    }
}

