/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;

public class ElasticsearchIndexIndexer
implements IndexIndexer<ElasticsearchDocumentObjectBuilder> {
    private final ElasticsearchWorkBuilderFactory factory;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;

    public ElasticsearchIndexIndexer(ElasticsearchWorkBuilderFactory factory, ElasticsearchWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.factory = factory;
        this.orchestrator = orchestrator;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String elasticsearchId = this.indexManagerContext.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.getRoutingKey();
        JsonObject document = this.indexManagerContext.createDocument(this.tenantId, id, documentContributor);
        Object work = this.factory.index(this.indexManagerContext.getMappedTypeName(), this.indexManagerContext.getElasticsearchIndexWriteName(), URLEncodedString.fromString(elasticsearchId), routingKey, document).build();
        return this.orchestrator.submit(work);
    }
}

