/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSet;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentElasticsearchWork;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.util.common.impl.Futures;

class ElasticsearchIndexingPlanWorkSet
implements ElasticsearchWorkSet {
    private final List<SingleDocumentElasticsearchWork<?>> works;
    private final CompletableFuture<IndexIndexingPlanExecutionReport> indexingPlanFuture;

    ElasticsearchIndexingPlanWorkSet(List<SingleDocumentElasticsearchWork<?>> works, CompletableFuture<IndexIndexingPlanExecutionReport> indexingPlanFuture) {
        this.works = new ArrayList(works);
        this.indexingPlanFuture = indexingPlanFuture;
    }

    public void submitTo(ElasticsearchWorkProcessor delegate) {
        delegate.beforeWorkSet();
        CompletableFuture[] workFutures = new CompletableFuture[this.works.size()];
        for (int i = 0; i < this.works.size(); ++i) {
            workFutures[i] = delegate.submit(this.works.get(i));
        }
        ((CompletableFuture)delegate.afterWorkSet().handle(Futures.handler((result, throwable) -> this.buildReport(workFutures, (Throwable)throwable)))).whenComplete(Futures.copyHandler(this.indexingPlanFuture));
    }

    private IndexIndexingPlanExecutionReport buildReport(CompletableFuture<?>[] finishedWorkFutures, Throwable throwable) {
        IndexIndexingPlanExecutionReport.Builder reportBuilder = IndexIndexingPlanExecutionReport.builder();
        for (int i = 0; i < finishedWorkFutures.length; ++i) {
            CompletableFuture<?> future = finishedWorkFutures[i];
            if (!future.isCompletedExceptionally()) continue;
            reportBuilder.throwable(Futures.getThrowableNow(future));
            SingleDocumentElasticsearchWork<?> work = this.works.get(i);
            reportBuilder.failingDocument(work.getDocumentReference());
        }
        if (throwable != null) {
            reportBuilder.throwable(throwable);
        }
        return reportBuilder.build();
    }

    public void markAsFailed(Throwable t) {
        this.indexingPlanFuture.completeExceptionally(t);
    }
}

