/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchDocumentReference;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.IndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleBulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentElasticsearchWork;
import org.hibernate.search.engine.backend.common.DocumentReference;

public class IndexWork
extends AbstractSimpleBulkableElasticsearchWork<Void>
implements SingleDocumentElasticsearchWork<Void> {
    private final String mappedTypeName;
    private final URLEncodedString id;

    private IndexWork(Builder builder) {
        super(builder);
        this.mappedTypeName = builder.mappedTypeName;
        this.id = builder.id;
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
        return null;
    }

    @Override
    public DocumentReference getDocumentReference() {
        return new ElasticsearchDocumentReference(this.mappedTypeName, this.id.original);
    }

    public static class Builder
    extends AbstractSimpleBulkableElasticsearchWork.AbstractBuilder<Builder>
    implements IndexWorkBuilder {
        private final String mappedTypeName;
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final URLEncodedString id;
        private final String routingKey;
        private final JsonObject document;

        public static Builder forElasticsearch67AndBelow(String mappedTypeName, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, URLEncodedString id, String routingKey, JsonObject document) {
            return new Builder(mappedTypeName, elasticsearchIndexName, typeName, id, routingKey, document);
        }

        public static Builder forElasticsearch7AndAbove(String mappedTypeName, URLEncodedString elasticsearchIndexName, URLEncodedString id, String routingKey, JsonObject document) {
            return new Builder(mappedTypeName, elasticsearchIndexName, null, id, routingKey, document);
        }

        private Builder(String mappedTypeName, URLEncodedString elasticsearchIndexName, URLEncodedString typeName, URLEncodedString id, String routingKey, JsonObject document) {
            super(elasticsearchIndexName, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.mappedTypeName = mappedTypeName;
            this.indexName = elasticsearchIndexName;
            this.typeName = typeName;
            this.id = id;
            this.routingKey = routingKey;
            this.document = document;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName).pathComponent(this.typeName != null ? this.typeName : Paths._DOC).pathComponent(this.id).body(this.document);
            if (this.routingKey != null) {
                builder.param("routing", this.routingKey);
            }
            return builder.build();
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            JsonObject index = new JsonObject();
            index.addProperty("_index", this.indexName.original);
            if (this.typeName != null) {
                index.addProperty("_type", this.typeName.original);
            }
            index.addProperty("_id", this.id.original);
            if (this.routingKey != null) {
                index.addProperty("routing", this.routingKey);
            }
            JsonObject result = new JsonObject();
            result.add("index", (JsonElement)index);
            return result;
        }

        @Override
        public IndexWork build() {
            return new IndexWork(this);
        }
    }
}

