/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.dialect.impl;

import java.lang.invoke.MethodHandles;
import java.util.OptionalInt;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch56ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch6ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.Elasticsearch7ModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.ElasticsearchModelDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch56ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch60ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch63ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch64ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch67ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.Elasticsearch70ProtocolDialect;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.ElasticsearchProtocolDialect;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDialectFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public ElasticsearchModelDialect createModelDialect(ElasticsearchVersion version) {
        int major = version.getMajor();
        OptionalInt minorOptional = version.getMinor();
        if (major < 5) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 5) {
            if (!minorOptional.isPresent()) {
                throw log.ambiguousElasticsearchVersion(version);
            }
            int minor = minorOptional.getAsInt();
            if (minor < 6) {
                throw log.unsupportedElasticsearchVersion(version);
            }
            return new Elasticsearch56ModelDialect();
        }
        if (major == 6) {
            return new Elasticsearch6ModelDialect();
        }
        return new Elasticsearch7ModelDialect();
    }

    public ElasticsearchProtocolDialect createProtocolDialect(ElasticsearchVersion version) {
        int major = version.getMajor();
        OptionalInt minorOptional = version.getMinor();
        if (!minorOptional.isPresent()) {
            throw new AssertionFailure("The Elasticsearch version is incomplete when creating the protocol dialect. There is probably a bug in Hibernate Search, please report it.");
        }
        int minor = minorOptional.getAsInt();
        if (major < 5) {
            throw log.unsupportedElasticsearchVersion(version);
        }
        if (major == 5) {
            if (minor < 6) {
                throw log.unsupportedElasticsearchVersion(version);
            }
            if (minor != 6) {
                log.unknownElasticsearchVersion(version);
            }
            return new Elasticsearch56ProtocolDialect();
        }
        if (major == 6) {
            if (minor < 3) {
                return new Elasticsearch60ProtocolDialect();
            }
            if (minor < 4) {
                return new Elasticsearch63ProtocolDialect();
            }
            if (minor < 7) {
                return new Elasticsearch64ProtocolDialect();
            }
            if (minor > 8) {
                log.unknownElasticsearchVersion(version);
            }
            return new Elasticsearch67ProtocolDialect();
        }
        if (major != 7) {
            log.unknownElasticsearchVersion(version);
        }
        return new Elasticsearch70ProtocolDialect();
    }
}

