/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.Map;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl.LowLevelIndexMetadataBuilder;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexModel {
    private final IndexNames names;
    private final String mappedTypeName;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final RootTypeMapping mapping;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private final Map<String, ElasticsearchIndexSchemaObjectNode> objectNodes;
    private final Map<String, ElasticsearchIndexSchemaFieldNode<?>> fieldNodes;

    public ElasticsearchIndexModel(IndexNames names, String mappedTypeName, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, RootTypeMapping mapping, ToDocumentIdentifierValueConverter<?> idDslConverter, Map<String, ElasticsearchIndexSchemaObjectNode> objectNodes, Map<String, ElasticsearchIndexSchemaFieldNode<?>> fieldNodes) {
        this.names = names;
        this.mappedTypeName = mappedTypeName;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.mapping = mapping;
        this.idDslConverter = idDslConverter;
        this.objectNodes = objectNodes;
        this.fieldNodes = fieldNodes;
    }

    public String getHibernateSearchIndexName() {
        return this.names.getHibernateSearch();
    }

    public IndexNames getNames() {
        return this.names;
    }

    public String getMappedTypeName() {
        return this.mappedTypeName;
    }

    public EventContext getEventContext() {
        return EventContexts.fromIndexName((String)this.getHibernateSearchIndexName());
    }

    public ToDocumentIdentifierValueConverter<?> getIdDslConverter() {
        return this.idDslConverter;
    }

    public ElasticsearchIndexSchemaObjectNode getObjectNode(String absolutePath) {
        return this.objectNodes.get(absolutePath);
    }

    public ElasticsearchIndexSchemaFieldNode<?> getFieldNode(String absoluteFieldPath) {
        return this.fieldNodes.get(absoluteFieldPath);
    }

    public void contributeLowLevelMetadata(LowLevelIndexMetadataBuilder builder) {
        builder.setAnalysisDefinitionRegistry(this.analysisDefinitionRegistry);
        builder.setMapping(this.mapping);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "names=" + this.names + ", mapping=" + this.mapping + "]";
    }
}

