/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;

public class ElasticsearchIndexSchemaObjectNode {
    private static final ElasticsearchIndexSchemaObjectNode ROOT = new ElasticsearchIndexSchemaObjectNode(null, null, Collections.emptyList(), null, false);
    private final ElasticsearchIndexSchemaObjectNode parent;
    private final String absolutePath;
    private final List<String> nestedPathHierarchy;
    private final ObjectFieldStorage storage;
    private final boolean multiValued;

    public static ElasticsearchIndexSchemaObjectNode root() {
        return ROOT;
    }

    public ElasticsearchIndexSchemaObjectNode(ElasticsearchIndexSchemaObjectNode parent, String absolutePath, List<String> nestedPathHierarchy, ObjectFieldStorage storage, boolean multiValued) {
        this.parent = parent;
        this.absolutePath = absolutePath;
        this.nestedPathHierarchy = Collections.unmodifiableList(nestedPathHierarchy);
        this.storage = ObjectFieldStorage.DEFAULT.equals((Object)storage) ? ObjectFieldStorage.FLATTENED : storage;
        this.multiValued = multiValued;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absolutePath=" + this.absolutePath + "]";
    }

    public ElasticsearchIndexSchemaObjectNode getParent() {
        return this.parent;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getAbsolutePath(String relativeFieldName) {
        return this.absolutePath == null ? relativeFieldName : this.absolutePath + "." + relativeFieldName;
    }

    public List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    public ObjectFieldStorage getStorage() {
        return this.storage;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }
}

