/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.AbstractElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;

public class ElasticsearchSimpleWorkOrchestrator
extends AbstractElasticsearchWorkOrchestrator<WorkExecution<?>>
implements ElasticsearchParallelWorkOrchestrator {
    private ElasticsearchWorkExecutionContext executionContext;

    public ElasticsearchSimpleWorkOrchestrator(String name, ElasticsearchLink link) {
        super(name, link);
    }

    @Override
    public <T> CompletableFuture<T> submit(NonBulkableWork<T> work) {
        WorkExecution<T> workExecution = new WorkExecution<T>(work);
        this.submit(workExecution);
        return workExecution.getResult();
    }

    protected void doStart(ConfigurationPropertySource propertySource) {
        this.executionContext = this.createWorkExecutionContext();
    }

    protected void doSubmit(WorkExecution<?> work) {
        work.execute(this.executionContext);
    }

    protected CompletableFuture<?> getCompletion() {
        return CompletableFuture.completedFuture(null);
    }

    protected void doStop() {
        this.executionContext = null;
    }

    static class WorkExecution<T> {
        private final NonBulkableWork<T> work;
        private CompletableFuture<T> result;

        WorkExecution(NonBulkableWork<T> work) {
            this.work = work;
        }

        public void execute(ElasticsearchWorkExecutionContext executionContext) {
            this.result = this.work.execute(executionContext);
        }

        public CompletableFuture<T> getResult() {
            return this.result;
        }
    }
}

