/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchDifferentNestedObjectCompatibilityChecker {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchScopeModel scopeModel;
    private final String fieldPath;
    private final List<String> nestedPathHierarchy;

    public static ElasticsearchDifferentNestedObjectCompatibilityChecker empty(ElasticsearchScopeModel scopeModel) {
        return new ElasticsearchDifferentNestedObjectCompatibilityChecker(scopeModel, null, null);
    }

    private ElasticsearchDifferentNestedObjectCompatibilityChecker(ElasticsearchScopeModel scopeModel, String fieldPath, List<String> nestedPathHierarchy) {
        this.scopeModel = scopeModel;
        this.fieldPath = fieldPath;
        this.nestedPathHierarchy = nestedPathHierarchy;
    }

    public ElasticsearchDifferentNestedObjectCompatibilityChecker combineAndCheck(String incomingFieldPath) {
        List<String> incomingNestedPathHierarchy = this.scopeModel.getNestedPathHierarchyForField(incomingFieldPath);
        if (this.fieldPath == null) {
            return new ElasticsearchDifferentNestedObjectCompatibilityChecker(this.scopeModel, incomingFieldPath, incomingNestedPathHierarchy);
        }
        if (!this.nestedPathHierarchy.equals(incomingNestedPathHierarchy)) {
            throw log.simpleQueryStringSpanningMultipleNestedPaths(this.fieldPath, ElasticsearchDifferentNestedObjectCompatibilityChecker.getLastPath(this.nestedPathHierarchy), incomingFieldPath, ElasticsearchDifferentNestedObjectCompatibilityChecker.getLastPath(incomingNestedPathHierarchy));
        }
        return this;
    }

    public List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    public boolean isEmpty() {
        return this.nestedPathHierarchy == null || this.nestedPathHierarchy.isEmpty();
    }

    private static String getLastPath(List<String> hierarchy) {
        if (hierarchy.isEmpty()) {
            return "<<root>>";
        }
        return hierarchy.get(hierarchy.size() - 1);
    }
}

