/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;

public abstract class AbstractElasticsearchSearchNestedPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder {
    private static final JsonAccessor<String> PATH_ACCESSOR = JsonAccessor.root().property("path").asString();
    private static final JsonAccessor<JsonObject> QUERY_ACCESSOR = JsonAccessor.root().property("query").asObject();
    private final List<String> nestedPathHierarchy;

    public AbstractElasticsearchSearchNestedPredicateBuilder(List<String> nestedPathHierarchy) {
        this.nestedPathHierarchy = nestedPathHierarchy;
    }

    @Override
    public final JsonObject build(ElasticsearchSearchPredicateContext context) {
        JsonObject result = super.build(context);
        if (this.nestedPathHierarchy != null && !this.nestedPathHierarchy.isEmpty()) {
            result = AbstractElasticsearchSearchNestedPredicateBuilder.applyImplicitNested(result, this.nestedPathHierarchy, context);
        }
        return result;
    }

    public static JsonObject applyImplicitNested(JsonObject partialResult, List<String> nestedPathHierarchy, ElasticsearchSearchPredicateContext context) {
        String path;
        JsonObject result = partialResult;
        for (int i = 0; i < nestedPathHierarchy.size() && !(path = nestedPathHierarchy.get(nestedPathHierarchy.size() - 1 - i)).equals(context.getNestedPath()); ++i) {
            JsonObject innerObject = new JsonObject();
            PATH_ACCESSOR.set(innerObject, path);
            QUERY_ACCESSOR.set(innerObject, result);
            JsonObject outerObject = new JsonObject();
            outerObject.add("nested", (JsonElement)innerObject);
            result = outerObject;
        }
        return result;
    }
}

