/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

public abstract class AbstractElasticsearchSearchPredicateBuilder
implements SearchPredicateBuilder<ElasticsearchSearchPredicateBuilder>,
ElasticsearchSearchPredicateBuilder {
    private static final JsonAccessor<Float> BOOST_ACCESSOR = JsonAccessor.root().property("boost").asFloat();
    private Float boost;
    private boolean withConstantScore = false;

    public void boost(float boost) {
        this.boost = Float.valueOf(boost);
    }

    public void constantScore() {
        this.withConstantScore = true;
    }

    public ElasticsearchSearchPredicateBuilder toImplementation() {
        return this;
    }

    @Override
    public JsonObject build(ElasticsearchSearchPredicateContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        if (this.boost != null && !this.withConstantScore) {
            BOOST_ACCESSOR.set(innerObject, this.boost);
        }
        JsonObject result = this.doBuild(context, outerObject, innerObject);
        return this.withConstantScore ? this.applyConstantScore(result) : result;
    }

    protected abstract JsonObject doBuild(ElasticsearchSearchPredicateContext var1, JsonObject var2, JsonObject var3);

    private JsonObject applyConstantScore(JsonObject filter) {
        JsonObject constantScore = new JsonObject();
        constantScore.add("filter", (JsonElement)filter);
        if (this.boost != null) {
            BOOST_ACCESSOR.set(constantScore, this.boost);
        }
        JsonObject result = new JsonObject();
        result.add("constant_score", (JsonElement)constantScore);
        return result;
    }
}

