/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;

class ElasticsearchNestedPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements NestedPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonAccessor<String> PATH_ACCESSOR = JsonAccessor.root().property("path").asString();
    private static final JsonAccessor<JsonObject> QUERY_ACCESSOR = JsonAccessor.root().property("query").asObject();
    private final String absoluteFieldPath;
    private ElasticsearchSearchPredicateBuilder nestedBuilder;

    ElasticsearchNestedPredicateBuilder(String absoluteFieldPath) {
        this.absoluteFieldPath = absoluteFieldPath;
    }

    public void nested(ElasticsearchSearchPredicateBuilder nestedBuilder) {
        this.nestedBuilder = nestedBuilder;
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        ElasticsearchSearchPredicateContext nestedContext = context.explicitNested(this.absoluteFieldPath);
        PATH_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        QUERY_ACCESSOR.set(innerObject, this.nestedBuilder.build(nestedContext));
        outerObject.add("nested", (JsonElement)innerObject);
        return outerObject;
    }
}

