/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchGeoPointFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.AbstractElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchGeoPointSpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchGeoPointSpatialWithinCirclePredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchGeoPointSpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchGeoPointFieldPredicateBuilderFactory
extends AbstractElasticsearchFieldPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ElasticsearchGeoPointFieldCodec CODEC = ElasticsearchGeoPointFieldCodec.INSTANCE;
    private final boolean searchable;

    public ElasticsearchGeoPointFieldPredicateBuilderFactory(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public boolean hasCompatibleCodec(ElasticsearchFieldPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchGeoPointFieldPredicateBuilderFactory castedOther = (ElasticsearchGeoPointFieldPredicateBuilderFactory)other;
        return this.searchable == castedOther.searchable;
    }

    @Override
    public boolean hasCompatibleConverter(ElasticsearchFieldPredicateBuilderFactory other) {
        return this.getClass().equals(other.getClass());
    }

    @Override
    public MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> createMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, ElasticsearchCompatibilityChecker converterChecker, ElasticsearchCompatibilityChecker analyzerChecker) {
        throw log.directValueLookupNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> createRangePredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, ElasticsearchCompatibilityChecker converterChecker) {
        throw log.rangesNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public SpatialWithinCirclePredicateBuilder<ElasticsearchSearchPredicateBuilder> createSpatialWithinCirclePredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchGeoPointSpatialWithinCirclePredicateBuilder(absoluteFieldPath, nestedPathHierarchy, CODEC);
    }

    @Override
    public SpatialWithinPolygonPredicateBuilder<ElasticsearchSearchPredicateBuilder> createSpatialWithinPolygonPredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchGeoPointSpatialWithinPolygonPredicateBuilder(absoluteFieldPath, nestedPathHierarchy);
    }

    @Override
    public SpatialWithinBoundingBoxPredicateBuilder<ElasticsearchSearchPredicateBuilder> createSpatialWithinBoundingBoxPredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchGeoPointSpatialWithinBoundingBoxPredicateBuilder(absoluteFieldPath, nestedPathHierarchy, CODEC);
    }

    private void checkSearchable(String absoluteFieldPath) {
        if (!this.searchable) {
            throw log.nonSearchableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

