/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchRangePredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.AbstractElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardMatchPredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchStandardFieldPredicateBuilderFactory<F>
extends AbstractElasticsearchFieldPredicateBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final DslConverter<?, ? extends F> converter;
    protected final DslConverter<F, ? extends F> rawConverter;
    protected final ElasticsearchFieldCodec<F> codec;
    private final boolean searchable;

    public ElasticsearchStandardFieldPredicateBuilderFactory(boolean searchable, DslConverter<?, ? extends F> converter, DslConverter<F, ? extends F> rawConverter, ElasticsearchFieldCodec<F> codec) {
        this.searchable = searchable;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.codec = codec;
    }

    @Override
    public boolean hasCompatibleCodec(ElasticsearchFieldPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldPredicateBuilderFactory castedOther = (ElasticsearchStandardFieldPredicateBuilderFactory)other;
        return this.searchable == castedOther.searchable && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean hasCompatibleConverter(ElasticsearchFieldPredicateBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchStandardFieldPredicateBuilderFactory castedOther = (ElasticsearchStandardFieldPredicateBuilderFactory)other;
        return this.converter.isCompatibleWith(castedOther.converter);
    }

    @Override
    public MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> createMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, ElasticsearchCompatibilityChecker converterChecker, ElasticsearchCompatibilityChecker analyzerChecker) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchStandardMatchPredicateBuilder<F>(searchContext, absoluteFieldPath, nestedPathHierarchy, this.converter, this.rawConverter, converterChecker, this.codec);
    }

    @Override
    public RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> createRangePredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, ElasticsearchCompatibilityChecker converterChecker) {
        this.checkSearchable(absoluteFieldPath);
        return new ElasticsearchRangePredicateBuilder<F>(searchContext, absoluteFieldPath, nestedPathHierarchy, this.converter, this.rawConverter, converterChecker, this.codec);
    }

    protected void checkSearchable(String absoluteFieldPath) {
        if (!this.searchable) {
            throw log.nonSearchableField(absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
        }
    }
}

