/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchNestedPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchStandardMatchPredicateBuilder<F>
extends AbstractElasticsearchSearchNestedPredicateBuilder
implements MatchPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> QUERY_ACCESSOR = JsonAccessor.root().property("query");
    private static final JsonObjectAccessor MATCH_ACCESSOR = JsonAccessor.root().property("match").asObject();
    protected final String absoluteFieldPath;
    private final ElasticsearchSearchContext searchContext;
    private final DslConverter<?, ? extends F> converter;
    private final DslConverter<F, ? extends F> rawConverter;
    private final ElasticsearchCompatibilityChecker converterChecker;
    private final ElasticsearchFieldCodec<F> codec;
    private JsonElement value;

    ElasticsearchStandardMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy, DslConverter<?, ? extends F> converter, DslConverter<F, ? extends F> rawConverter, ElasticsearchCompatibilityChecker converterChecker, ElasticsearchFieldCodec<F> codec) {
        super(nestedPathHierarchy);
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.converterChecker = converterChecker;
        this.codec = codec;
    }

    public void fuzzy(int maxEditDistance, int exactPrefixLength) {
        throw log.textPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void analyzer(String analyzerName) {
        throw log.textPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void skipAnalysis() {
        throw log.textPredicatesNotSupportedByFieldType(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void value(Object value, ValueConvert convert) {
        DslConverter<?, F> dslToIndexConverter = this.getDslToIndexConverter(convert);
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.value = this.codec.encode(converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        QUERY_ACCESSOR.set(innerObject, this.value);
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        MATCH_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private DslConverter<?, ? extends F> getDslToIndexConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return this.rawConverter;
            }
        }
        this.converterChecker.failIfNotCompatible();
        return this.converter;
    }
}

