/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.analysis.impl.AnalysisDefinition;
import org.hibernate.search.backend.elasticsearch.validation.impl.AnalysisJsonElementEquivalence;
import org.hibernate.search.backend.elasticsearch.validation.impl.AnalysisParameterEquivalenceRegistry;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

class AnalysisDefinitionValidator<T extends AnalysisDefinition>
implements Validator<T> {
    private final AnalysisParameterEquivalenceRegistry equivalences;

    AnalysisDefinitionValidator(AnalysisParameterEquivalenceRegistry equivalences) {
        this.equivalences = equivalences;
    }

    @Override
    public void validate(ValidationErrorCollector errorCollector, T expectedDefinition, T actualDefinition) {
        String defaultedActualType;
        String expectedType = ((AnalysisDefinition)expectedDefinition).getType();
        String actualType = ((AnalysisDefinition)actualDefinition).getType();
        String defaultedExpectedType = expectedType == null ? this.getDefaultType() : expectedType;
        String string = defaultedActualType = actualType == null ? this.getDefaultType() : actualType;
        if (!Objects.equals(defaultedExpectedType, defaultedActualType)) {
            errorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidAnalysisDefinitionType(expectedType, actualType));
        }
        String typeName = ((AnalysisDefinition)expectedDefinition).getType();
        Validator<JsonElement> parameterValidator = (theErrorCollector, expected, actual) -> {
            AnalysisJsonElementEquivalence parameterEquivalence = this.equivalences.get(typeName, theErrorCollector.getCurrentName());
            if (!parameterEquivalence.isEquivalent((JsonElement)expected, (JsonElement)actual)) {
                theErrorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(expected, actual));
            }
        };
        parameterValidator.validateAllIncludingUnexpected(errorCollector, ValidationContextType.ANALYSIS_DEFINITION_PARAMETER, ((AnalysisDefinition)expectedDefinition).getParameters(), ((AnalysisDefinition)actualDefinition).getParameters());
    }

    protected String getDefaultType() {
        return null;
    }
}

