/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.validation.impl;

import com.google.gson.JsonElement;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.LeafValidators;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;

public class IndexAliasDefinitionValidator
implements Validator<IndexAliasDefinition> {
    @Override
    public void validate(ValidationErrorCollector errorCollector, IndexAliasDefinition expectedDefinition, IndexAliasDefinition actualDefinition) {
        if (Boolean.TRUE.equals(expectedDefinition.getWriteIndex())) {
            LeafValidators.EQUAL.validate(errorCollector, ValidationContextType.ALIAS_ATTRIBUTE, "is_write_index", Boolean.TRUE, actualDefinition.getWriteIndex());
        }
        Validator<JsonElement> parameterValidator = (theErrorCollector, expected, actual) -> {
            if (!Objects.equals(expected, actual)) {
                theErrorCollector.addError(ElasticsearchValidationMessages.INSTANCE.invalidValue(expected, actual));
            }
        };
        parameterValidator.validateAllIncludingUnexpected(errorCollector, ValidationContextType.ALIAS_ATTRIBUTE, expectedDefinition.getExtraAttributes(), actualDefinition.getExtraAttributes());
    }
}

