/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;

public class ElasticsearchIndexWorkspace
implements IndexWorkspace {
    private final ElasticsearchWorkBuilderFactory builderFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchParallelWorkOrchestrator orchestrator;
    private final URLEncodedString indexName;
    private final DetachedBackendSessionContext sessionContext;

    public ElasticsearchIndexWorkspace(ElasticsearchWorkBuilderFactory builderFactory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchParallelWorkOrchestrator orchestrator, WorkExecutionIndexManagerContext indexManagerContext, DetachedBackendSessionContext sessionContext) {
        this.builderFactory = builderFactory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexManagerContext.getElasticsearchIndexWriteName();
        this.sessionContext = sessionContext;
    }

    public CompletableFuture<?> mergeSegments() {
        return this.orchestrator.submit((NonBulkableWork)this.builderFactory.mergeSegments().index(this.indexName).build());
    }

    public CompletableFuture<?> purge(Set<String> routingKeys) {
        JsonArray filters = new JsonArray();
        JsonObject filter = this.multiTenancyStrategy.getFilterOrNull(this.sessionContext.getTenantIdentifier());
        if (filter != null) {
            filters.add((JsonElement)filter);
        }
        if (!routingKeys.isEmpty()) {
            filters.add((JsonElement)Queries.anyTerm("_routing", routingKeys));
        }
        JsonObject payload = new JsonObject();
        payload.add("query", (JsonElement)Queries.boolFilter(Queries.matchAll(), filters));
        return this.orchestrator.submit((NonBulkableWork)this.builderFactory.deleteByQuery(this.indexName, payload).routingKeys(routingKeys).build());
    }

    public CompletableFuture<?> flush() {
        return this.orchestrator.submit((NonBulkableWork)this.builderFactory.flush().index(this.indexName).build());
    }

    public CompletableFuture<?> refresh() {
        return this.orchestrator.submit((NonBulkableWork)this.builderFactory.refresh().index(this.indexName).build());
    }
}

