/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.IndexSchemaRootContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldTemplate;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldTemplate;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaRootNode;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.NamedDynamicTemplate;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RoutingType;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchIndexFieldTypeFactory;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryProvider;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaRootNodeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexSchemaRootNodeBuilder
extends AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaRootNodeBuilder {
    private final ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider;
    private final EventContext indexEventContext;
    private final List<IndexSchemaRootContributor> schemaRootContributors = new ArrayList<IndexSchemaRootContributor>();
    private final IndexNames indexNames;
    private final String mappedTypeName;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private RoutingType routing = null;
    private ToDocumentIdentifierValueConverter<?> idDslConverter;

    public ElasticsearchIndexSchemaRootNodeBuilder(ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider, EventContext indexEventContext, IndexNames indexNames, String mappedTypeName, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.typeFactoryProvider = typeFactoryProvider;
        this.indexEventContext = indexEventContext;
        this.indexNames = indexNames;
        this.mappedTypeName = mappedTypeName;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public EventContext getEventContext() {
        return this.getIndexEventContext().append(EventContexts.indexSchemaRoot());
    }

    public ElasticsearchIndexFieldTypeFactory createTypeFactory(IndexFieldTypeDefaultsProvider defaultsProvider) {
        return this.typeFactoryProvider.create(this.indexEventContext, defaultsProvider);
    }

    public void explicitRouting() {
        this.routing = RoutingType.REQUIRED;
    }

    public void idDslConverter(ToDocumentIdentifierValueConverter<?> idDslConverter) {
        this.idDslConverter = idDslConverter;
    }

    public void addSchemaRootContributor(IndexSchemaRootContributor schemaRootContributor) {
        this.schemaRootContributors.add(schemaRootContributor);
    }

    public ElasticsearchIndexModel build() {
        final RootTypeMapping mapping = new RootTypeMapping();
        if (this.routing != null) {
            mapping.setRouting(this.routing);
        }
        for (IndexSchemaRootContributor schemaRootContributor : this.schemaRootContributors) {
            schemaRootContributor.contribute(mapping);
        }
        mapping.setDynamic(this.resolveSelfDynamicType());
        final HashMap<String, ElasticsearchIndexSchemaObjectFieldNode> objectNodes = new HashMap<String, ElasticsearchIndexSchemaObjectFieldNode>();
        final HashMap fieldNodes = new HashMap();
        final ArrayList<ElasticsearchIndexSchemaObjectFieldTemplate> objectFieldTemplates = new ArrayList<ElasticsearchIndexSchemaObjectFieldTemplate>();
        final ArrayList<ElasticsearchIndexSchemaFieldTemplate> fieldTemplates = new ArrayList<ElasticsearchIndexSchemaFieldTemplate>();
        ElasticsearchIndexSchemaNodeCollector collector = new ElasticsearchIndexSchemaNodeCollector(){

            @Override
            public void collect(String absolutePath, ElasticsearchIndexSchemaObjectFieldNode node) {
                objectNodes.put(absolutePath, node);
            }

            @Override
            public void collect(String absoluteFieldPath, ElasticsearchIndexSchemaFieldNode<?> node) {
                fieldNodes.put(absoluteFieldPath, node);
            }

            @Override
            public void collect(ElasticsearchIndexSchemaObjectFieldTemplate template) {
                objectFieldTemplates.add(template);
            }

            @Override
            public void collect(ElasticsearchIndexSchemaFieldTemplate template) {
                fieldTemplates.add(template);
            }

            @Override
            public void collect(NamedDynamicTemplate templateForMapping) {
                mapping.addDynamicTemplate(templateForMapping);
            }
        };
        ArrayList<AbstractElasticsearchIndexSchemaFieldNode> staticChildren = new ArrayList<AbstractElasticsearchIndexSchemaFieldNode>();
        ElasticsearchIndexSchemaRootNode rootNode = new ElasticsearchIndexSchemaRootNode(staticChildren);
        this.contributeChildren(mapping, rootNode, collector, staticChildren);
        return new ElasticsearchIndexModel(this.indexNames, this.mappedTypeName, this.analysisDefinitionRegistry, mapping, (ToDocumentIdentifierValueConverter<?>)(this.idDslConverter == null ? new StringToDocumentIdentifierValueConverter() : this.idDslConverter), rootNode, (Map<String, ElasticsearchIndexSchemaObjectFieldNode>)objectNodes, fieldNodes, (List<ElasticsearchIndexSchemaObjectFieldTemplate>)objectFieldTemplates, (List<ElasticsearchIndexSchemaFieldTemplate>)fieldTemplates);
    }

    @Override
    ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this;
    }

    @Override
    String getAbsolutePath() {
        return null;
    }

    EventContext getIndexEventContext() {
        return this.indexEventContext;
    }
}

