/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.List;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexSchemaFieldNode<F>
extends AbstractElasticsearchIndexSchemaFieldNode
implements IndexValueFieldDescriptor {
    private final List<String> nestedPathHierarchy;
    private final ElasticsearchIndexFieldType<F> type;

    public ElasticsearchIndexSchemaFieldNode(ElasticsearchIndexSchemaObjectNode parent, String relativeFieldName, IndexFieldInclusion inclusion, boolean multiValued, ElasticsearchIndexFieldType<F> type) {
        super(parent, relativeFieldName, inclusion, multiValued);
        this.nestedPathHierarchy = parent.getNestedPathHierarchy();
        this.type = type;
    }

    public boolean isObjectField() {
        return false;
    }

    public boolean isValueField() {
        return true;
    }

    @Override
    public ElasticsearchIndexSchemaObjectFieldNode toObjectField() {
        throw log.invalidIndexElementTypeValueFieldIsNotObjectField(this.absolutePath);
    }

    @Override
    public ElasticsearchIndexSchemaFieldNode<F> toValueField() {
        return this;
    }

    public String getNestedPath() {
        return this.nestedPathHierarchy.isEmpty() ? null : this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1);
    }

    public List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    public ElasticsearchIndexFieldType<F> type() {
        return this.type;
    }

    public <T> ElasticsearchIndexSchemaFieldNode<? super T> withValueType(Class<T> expectedSubType, EventContext eventContext) {
        if (!this.type.getValueType().isAssignableFrom(expectedSubType)) {
            throw log.invalidFieldValueType(this.type.getValueType(), expectedSubType, eventContext.append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath)));
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("parent=").append(this.parent).append(", type=").append(this.type).append("]");
        return sb.toString();
    }
}

