/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.AbstractTypingJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.ArrayElementJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;

public class JsonArrayAccessorImpl
extends AbstractTypingJsonAccessor<JsonArray>
implements JsonArrayAccessor,
JsonCompositeAccessor<JsonArray> {
    public JsonArrayAccessorImpl(JsonAccessor<JsonElement> parentAccessor) {
        super(parentAccessor);
    }

    @Override
    protected JsonElementType<JsonArray> getExpectedElementType() {
        return JsonElementTypes.ARRAY;
    }

    @Override
    public JsonArray getOrCreate(JsonObject root) {
        return this.getOrCreate(root, JsonArray::new);
    }

    @Override
    public UnknownTypeJsonAccessor element(int index) {
        return new ArrayElementJsonAccessor(this, index);
    }

    @Override
    public void addElementIfAbsent(JsonObject root, JsonElement newValue) {
        JsonArray array = this.getOrCreate(root);
        if (!array.contains(newValue)) {
            array.add(newValue);
        }
    }
}

