/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchFieldSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=400000, max=409999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 400000;
    public static final int ID_OFFSET_3 = 400500;

    @Message(id=400007, value="Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s")
    public SearchException elasticsearchRequestFailed(@FormatWith(value=ElasticsearchRequestFormatter.class) ElasticsearchRequest var1, @FormatWith(value=ElasticsearchResponseFormatter.class) ElasticsearchResponse var2, String var3, @Cause Exception var4);

    @Message(id=400008, value="Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s")
    public SearchException elasticsearchBulkedRequestFailed(@FormatWith(value=ElasticsearchJsonObjectFormatter.class) JsonObject var1, @FormatWith(value=ElasticsearchJsonObjectFormatter.class) JsonObject var2, String var3, @Cause Exception var4);

    @Message(id=400010, value="Elasticsearch connection time-out; check the cluster status, it should be 'green'")
    public SearchException elasticsearchRequestTimeout();

    @Message(id=400020, value="Could not create mapping for index '%1$s': %2$s")
    public SearchException elasticsearchMappingCreationFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=400022, value="Invalid index status: '%1$s'. Valid statuses are: %2$s.")
    public SearchException invalidIndexStatus(String var1, List<String> var2);

    @Message(id=400024, value="Index '%1$s' failed to reach status '%2$s' after %3$s.")
    public SearchException unexpectedIndexStatus(URLEncodedString var1, String var2, String var3, @Cause Exception var4);

    @Message(id=400034, value="Could not retrieve the index metadata from Elasticsearch")
    public SearchException elasticsearchIndexMetadataRetrievalFailed(@Cause Throwable var1);

    @Message(id=400035, value="Could not update mappings in index '%1$s': %2$s")
    public SearchException schemaUpdateFailed(URLEncodedString var1, String var2, @Cause Exception var3);

    @Message(id=400050, value="Index aliases [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.")
    public SearchException indexMissing(URLEncodedString var1, URLEncodedString var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400053, value="Executing Elasticsearch query on '%s' with parameters '%s': <%s>")
    public void executingElasticsearchQuery(String var1, Map<String, String> var2, String var3);

    @Message(id=400055, value="Multiple tokenizer definitions with the same name: '%1$s'. The tokenizer names must be unique.")
    public SearchException tokenizerNamingConflict(String var1);

    @Message(id=400056, value="Multiple char filter definitions with the same name: '%1$s'. The char filter names must be unique.")
    public SearchException charFilterNamingConflict(String var1);

    @Message(id=400057, value="Multiple token filter definitions with the same name: '%1$s'. The token filter names must be unique.")
    public SearchException tokenFilterNamingConflict(String var1);

    @Message(id=400067, value="Could not update settings for index '%1$s'")
    public SearchException elasticsearchSettingsUpdateFailed(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400069, value="Closed Elasticsearch index '%1$s' automatically.")
    public void closedIndex(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400070, value="Opened Elasticsearch index '%1$s' automatically.")
    public void openedIndex(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400073, value="Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.")
    public void usingPasswordOverHttp();

    @Message(id=400074, value="Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.")
    public SearchException analyzerNamingConflict(String var1);

    @Message(id=400075, value="Error while applying analysis configuration: %1$s")
    public SearchException unableToApplyAnalysisConfiguration(String var1, @Cause Exception var2);

    @Message(id=400076, value="Invalid analyzer definition for name '%1$s'. Analyzer definitions must at least define the tokenizer.")
    public SearchException invalidElasticsearchAnalyzerDefinition(String var1);

    @Message(id=400077, value="Invalid tokenizer definition for name '%1$s'. Tokenizer definitions must at least define the tokenizer type.")
    public SearchException invalidElasticsearchTokenizerDefinition(String var1);

    @Message(id=400078, value="Invalid char filter definition for name '%1$s'. Char filter definitions must at least define the char filter type.")
    public SearchException invalidElasticsearchCharFilterDefinition(String var1);

    @Message(id=400079, value="Invalid token filter definition for name '%1$s'. Token filter definitions must at least define the token filter type.")
    public SearchException invalidElasticsearchTokenFilterDefinition(String var1);

    @Message(id=400080, value="Failed to detect the Elasticsearch version running on the cluster: %s")
    public SearchException failedToDetectElasticsearchVersion(String var1, @Cause Exception var2);

    @Message(id=400081, value="An unsupported Elasticsearch version runs on the Elasticsearch cluster: '%s'. Please refer to the documentation to know which versions are supported.")
    public SearchException unsupportedElasticsearchVersion(ElasticsearchVersion var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400082, value="Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'.")
    public void executedRequest(String var1, String var2, Map<String, String> var3, int var4, long var5, int var7, String var8);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400085, value="Hibernate Search may not work correctly, because an unknown Elasticsearch version runs on the Elasticsearch cluster: '%s'.")
    public void unknownElasticsearchVersion(ElasticsearchVersion var1);

    @Message(id=400086, value="Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.")
    public SearchException normalizerNamingConflict(String var1);

    @Message(id=400089, value="Failed to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'.")
    public SearchException failedToParseElasticsearchResponse(int var1, String var2, @Cause Exception var3);

    @Message(id=400090, value="Elasticsearch response indicates a failure.")
    public SearchException elasticsearchResponseIndicatesFailure();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=400093, value="Executed Elasticsearch HTTP %s request to path '%s' with query parameters %s and %d objects in payload in %dms. Response had status %d '%s'. Request body: <%s>. Response body: <%s>")
    public void executedRequest(String var1, String var2, Map<String, String> var3, int var4, long var5, int var7, String var8, String var9, String var10);

    @Message(id=400502, value="A multi-index scope cannot include both an Elasticsearch index and another type of index. Base scope was: '%1$s', Elasticsearch index was: '%2$s'")
    public SearchException cannotMixElasticsearchScopeWithOtherType(IndexScopeBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400503, value="A multi-index scope cannot span multiple Elasticsearch backends. Base scope was: '%1$s', index from another backend was: '%2$s'")
    public SearchException cannotMixElasticsearchScopeWithOtherBackend(IndexScopeBuilder var1, ElasticsearchIndexManager var2, @Param EventContext var3);

    @Message(id=400504, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForSearch(String var1, @Param EventContext var2);

    @Message(id=400506, value="The Elasticsearch extension can only be applied to objects derived from the Elasticsearch backend. Was applied to '%1$s' instead.")
    public SearchException elasticsearchExtensionOnUnknownType(Object var1);

    @Message(id=400508, value="An Elasticsearch query cannot include search predicates built using a non-Elasticsearch search scope. Given predicate was: '%1$s'")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherPredicates(SearchPredicate var1);

    @Message(id=400509, value="Field '%1$s' is not an object field.")
    public SearchException nonObjectFieldForNestedQuery(String var1, @Param EventContext var2);

    @Message(id=400510, value="Object field '%1$s' is not stored as nested.")
    public SearchException nonNestedFieldForNestedQuery(String var1, @Param EventContext var2);

    @Message(id=400511, value="An Elasticsearch query cannot include search sorts built using a non-Elasticsearch search scope. Given sort was: '%1$s'")
    public SearchException cannotMixElasticsearchSearchSortWithOtherSorts(SearchSort var1);

    @Message(id=400514, value="Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.")
    public SearchException multiTenancyRequiredButNotSupportedByBackend(String var1, @Param EventContext var2);

    @Message(id=400515, value="Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidMultiTenancyStrategyName(String var1, List<String> var2);

    @Message(id=400516, value="Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.")
    public SearchException tenantIdProvidedButMultiTenancyDisabled(String var1, @Param EventContext var2);

    @Message(id=400517, value="Backend has multi-tenancy enabled, but no tenant identifier is provided.")
    public SearchException multiTenancyEnabledButNoTenantIdProvided(@Param EventContext var1);

    @Message(id=400518, value="Attempt to unwrap the Elasticsearch low-level client to %1$s, but the client can only be unwrapped to %2$s.")
    public SearchException clientUnwrappingWithUnkownType(Class<?> var1, Class<?> var2);

    @Message(id=400519, value="Attempt to unwrap an Elasticsearch backend to '%1$s', but this backend can only be unwrapped to '%2$s'.")
    public SearchException backendUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400520, value="The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.")
    public SearchException indexSchemaNodeNameConflict(String var1, @Param EventContext var2);

    @Message(id=400523, value="Range lookups (range predicates, range aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.")
    public SearchException rangesNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=400524, value="Direct value lookups (match predicates, terms aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.")
    public SearchException directValueLookupNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=400525, value="Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.")
    public SearchException invalidFieldForDocumentElement(String var1, String var2);

    @Message(id=400526, value="Expected data was missing in the Elasticsearch response.")
    public AssertionFailure elasticsearchResponseMissingData();

    @Message(id=400527, value="Spatial predicates are not supported by this field's type.")
    public SearchException spatialPredicatesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400528, value="Distance related operations are not supported by this field's type.")
    public SearchException distanceOperationsNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400529, value="Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'")
    public SearchException minimumShouldMatchConflictingConstraints(int var1);

    @Message(id=400530, value="Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the name or alias '%3$s'")
    public SearchException conflictingIndexNames(String var1, String var2, String var3);

    @Message(id=400531, value="Could not resolve index name '%1$s' to an entity type: %2$s")
    public SearchException elasticsearchResponseUnknownIndexName(String var1, String var2, @Cause Exception var3);

    @Message(id=400532, value="Unable to convert DSL parameter: %1$s")
    public SearchException cannotConvertDslParameter(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=400533, value="Attempt to unwrap an Elasticsearch index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.")
    public SearchException indexManagerUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400534, value="Invalid typed analyzer definition for name '%1$s'. Typed analyzer definitions must at least define the analyzer type.")
    public SearchException invalidElasticsearchTypedAnalyzerDefinition(String var1);

    @Message(id=400535, value="Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.")
    public SearchException cannotApplyAnalyzerAndNormalizer(String var1, String var2, @Param EventContext var3);

    @Message(id=400536, value="Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.")
    public SearchException cannotUseAnalyzerOnSortableField(String var1, @Param EventContext var2);

    @Message(id=400537, value="Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'")
    public SearchException analysisComponentParameterConflict(String var1, JsonElement var2, JsonElement var3);

    @Message(id=400538, value="An Elasticsearch query cannot include search projections built using a non-Elasticsearch search scope. Given projection was: '%1$s'")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherProjections(SearchProjection<?> var1);

    @Message(id=400539, value="Invalid type '%2$s' for projection on field '%1$s'.")
    public SearchException invalidProjectionInvalidType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400540, value="Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.")
    public SearchException traditionalSortNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=400541, value="Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForPredicate(String var1, ElasticsearchFieldPredicateBuilderFactory var2, ElasticsearchFieldPredicateBuilderFactory var3, @Param EventContext var4);

    @Message(id=400542, value="Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForSort(String var1, ElasticsearchFieldSortBuilderFactory var2, ElasticsearchFieldSortBuilderFactory var3, @Param EventContext var4);

    @Message(id=400543, value="Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForProjection(String var1, ElasticsearchFieldProjectionBuilderFactory var2, ElasticsearchFieldProjectionBuilderFactory var3, @Param EventContext var4);

    @Message(id=400544, value="Failed to shut down the Elasticsearch backend.")
    public SearchException failedToShutdownBackend(@Cause Exception var1, @Param EventContext var2);

    @Message(id=400545, value="Cannot guess field type for input type %1$s.")
    public SearchException cannotGuessFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=400547, value="Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.")
    public SearchException nonProjectableField(String var1, @Param EventContext var2);

    @Message(id=400548, value="Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.")
    public SearchException unsortableField(String var1, @Param EventContext var2);

    @Message(id=400549, value="Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.")
    public SearchException conflictingIdentifierTypesForPredicate(ToDocumentIdentifierValueConverter<?> var1, ToDocumentIdentifierValueConverter<?> var2, @Param EventContext var3);

    @Message(id=400550, value="Failed to shut down the Elasticsearch index manager with name '%1$s'.")
    public SearchException failedToShutdownIndexManager(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=400553, value="Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.")
    public SearchException textPredicatesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400554, value="Incomplete field definition. You must call toReference() to complete the field definition.")
    public SearchException incompleteFieldDefinition(@Param EventContext var1);

    @Message(id=400555, value="Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.")
    public SearchException cannotCreateReferenceMultipleTimes(@Param EventContext var1);

    @Message(id=400556, value="Invalid Elasticsearch version: '%1$s'. The version must be in the form 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.")
    public SearchException invalidElasticsearchVersion(String var1);

    @Message(id=400559, value="Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.")
    public SearchException unexpectedElasticsearchVersion(ElasticsearchVersion var1, ElasticsearchVersion var2);

    @Message(id=400560, value="Elasticsearch backend does not support skip analysis on not analyzed field: '%1$s'.")
    public SearchException skipAnalysisOnKeywordField(String var1, @Param EventContext var2);

    @Message(id=400561, value="Ambiguous Elasticsearch version: '%s'. This version matches multiple dialects. Please use a more precise version to remove the ambiguity.")
    public SearchException ambiguousElasticsearchVersion(ElasticsearchVersion var1);

    @Message(id=400562, value="Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.")
    public SearchException cannotUseIndexNullAsAndAnalyzer(String var1, String var2, @Param EventContext var3);

    @Message(id=400563, value="Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.")
    public SearchException multipleValuesForSingleValuedField(String var1);

    @Message(id=400564, value="explain(String id) cannot be used when the query targets multiple indexes. Use explain(String indexName, String id) and pass one of %1$s as the index name.")
    public SearchException explainRequiresIndexName(Set<String> var1);

    @Message(id=400565, value="The given mapped type name '%2$s' is not among the mapped type targeted by this query: %1$s.")
    public SearchException explainRequiresTypeTargetedByQuery(Set<String> var1, String var2);

    @Message(id=400566, value="Document with id '%1$s' does not exist in the targeted index and thus its match cannot be explained.")
    public SearchException explainUnknownDocument(URLEncodedString var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400567, value="'%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock")
    public void interruptedWhileWaitingForIndexActivity(String var1, @Cause InterruptedException var2);

    @Message(id=400568, value="Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.")
    public SearchException nullDecimalScale(@Param EventContext var1);

    @Message(id=400569, value="The value '%1$s' cannot be indexed because its absolute value is too large.")
    public SearchException scaledNumberTooLarge(Number var1);

    @Message(id=400570, value="Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.")
    public SearchException invalidDecimalScale(Integer var1, @Param EventContext var2);

    @Message(id=400571, value="Field '%1$s' is not searchable. Make sure the field is marked as searchable.")
    public SearchException nonSearchableField(String var1, @Param EventContext var2);

    @Message(id=400572, value="The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException predicateDefinedOnDifferentIndexes(SearchPredicate var1, Set<String> var2, Set<String> var3);

    @Message(id=400573, value="The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException sortDefinedOnDifferentIndexes(SearchSort var1, Set<String> var2, Set<String> var3);

    @Message(id=400574, value="The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=400575, value="Multiple index conflicting models on nested document paths targeting '%1$s'. '%2$s' vs. '%3$s'.")
    public SearchException conflictingNestedDocumentPaths(String var1, String var2, String var3, @Param EventContext var4);

    @Message(id=400576, value="Cannot apply an analyzer on an aggregable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.")
    public SearchException cannotUseAnalyzerOnAggregableField(String var1, @Param EventContext var2);

    @Message(id=400577, value="Aggregations are not enabled for field '%1$s'. Make sure the field is marked as aggregable.")
    public SearchException nonAggregableField(String var1, @Param EventContext var2);

    @Message(id=400578, value="Invalid type '%2$s' for aggregation on field '%1$s'.")
    public SearchException invalidAggregationInvalidType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400579, value="Multiple conflicting types to build an aggregation for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForAggregation(String var1, ElasticsearchFieldAggregationBuilderFactory var2, ElasticsearchFieldAggregationBuilderFactory var3, @Param EventContext var4);

    @Message(id=400580, value="Elasticsearch range aggregations only accept ranges in the canonical form: (-Infinity, <value>) or [<value1>, <value2>) or [<value>, +Infinity). The given range is not in canonical form: '%1$s'.")
    public SearchException elasticsearchRangeAggregationRequiresCanonicalFormForRanges(Range<?> var1);

    @Message(id=400581, value="An Elasticsearch query cannot include search aggregations built using a non-Elasticsearch search scope. Given aggregation was: '%1$s'")
    public SearchException cannotMixElasticsearchSearchQueryWithOtherAggregations(SearchAggregation<?> var1);

    @Message(id=400582, value="The aggregation '%1$s' is defined on a scope targeting different indexes. Aggregation is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=400583, value="Terms aggregations are not supported by this field's type (string field with analyzed). Use a normalized field instead.")
    public SearchException termsAggregationsNotSupportedByAnalyzedTextFieldType(@Param EventContext var1);

    @Message(id=400584, value="Range aggregations are not supported by this field's type.")
    public SearchException rangeAggregationsNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=400585, value="Multiple aggregations with the same key: '%1$s'")
    public SearchException duplicateAggregationKey(@FormatWith(value=AggregationKeyFormatter.class) AggregationKey var1);

    @Message(id=400586, value="Multiple index conflicting models on nested document paths targeting '%1$s'. '%2$s' vs. '%3$s'.")
    public SearchException conflictingNestedDocumentPathHierarchy(String var1, List<String> var2, List<String> var3, @Param EventContext var4);

    @Message(id=400587, value="Cannot apply a search analyzer if an analyzer has not been defined on the same field. Search analyzer: '%1$s'.")
    public SearchException searchAnalyzerWithoutAnalyzer(String var1, @Param EventContext var2);

    @Message(id=400588, value="The operation failed due to the failure of the call to the bulk REST API.")
    public SearchException elasticsearchFailedBecauseOfBulkFailure(@Cause Throwable var1);

    @Message(id=400589, value="Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.")
    public SearchException invalidHostAndPort(String var1, @Cause Exception var2);

    @Message(id=400590, value="Request exceeded the timeout of %1$s: '%2$s'.")
    public SearchTimeoutException timedOut(@FormatWith(value=DurationInSecondsAndFractionsFormatter.class) Duration var1, @FormatWith(value=ElasticsearchRequestFormatter.class) ElasticsearchRequest var2);

    @Message(id=400591, value="Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidTypeNameMappingStrategyName(String var1, List<String> var2);

    @Message(id=400592, value="Missing field '%1$s' for one of the search hits. The document was probably indexed with a different configuration: full reindexing is necessary.")
    public SearchException missingTypeFieldInDocument(String var1);

    @Message(id=400593, value="Index aliases [%1$s, %2$s] are assigned to a single Hibernate Search index,  but they are already defined in Elasticsearch and point to multiple distinct indexes: %3$s.")
    public SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(URLEncodedString var1, URLEncodedString var2, Set<String> var3);

    @Message(id=400594, value="Index primary name  '%1$s' does not match the expected pattern '%2$s'.")
    public SearchException invalidIndexPrimaryName(String var1, Pattern var2);

    @Message(id=400595, value="Unique key '%1$s' extracted from the index name does not match any of %2$s")
    public SearchException invalidIndexUniqueKey(String var1, Set<String> var2);

    @Message(id=400596, value="Write alias and read alias must be different, but were set to the same value: '%1$s'.")
    public SearchException sameWriteAndReadAliases(URLEncodedString var1, @Param EventContext var2);

    @Message(id=400597, value="Invalid Elasticsearch version: '%1$s'. When version_check.enabled is set to false,  the version must at least be in the form 'x.y', where 'x' and 'y' are integers")
    public SearchException invalidElasticsearchVersionCheckConfiguration(String var1);

    @Message(id=400598, value="The lifecycle strategy cannot be set at the index level anymore. Set the schema management strategy via the property 'hibernate.search.schema_management.strategy' instead.")
    public SearchException lifecycleStrategyMovedToMapper();

    @Message(id=400599, value="Simple query string targets fields [%1$s, %3$s] spanning multiple nested paths: %2$s, %4$s.")
    public SearchException simpleQueryStringSpanningMultipleNestedPaths(String var1, String var2, String var3, String var4);

    @Message(id=400600, value="Cannot compute the median across nested documents.")
    public SearchException cannotComputeMedianAcrossNested(@Param EventContext var1);

    @Message(id=400601, value="Cannot compute the sum, average or median of a text field. Only min and max are supported.")
    public SearchException cannotComputeSumOrAvgOrMedianForStringField(@Param EventContext var1);

    @Message(id=400602, value="Cannot compute the sum of a temporal field. Only min, max, avg and median are supported.")
    public SearchException cannotComputeSumForTemporalField(@Param EventContext var1);

    @Message(id=400603, value="Cannot compute the sum for a distance sort. Only min, max, avg and median are supported.")
    public SearchException cannotComputeSumForDistanceSort(@Param EventContext var1);

    @Message(id=400604, value="Field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.")
    public SearchException cannotFilterSortOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=400605, value="Predicate targets unexpected fields %2$s. Only fields that are contained in the nested object with path '%1$s' are allowed here.")
    public SearchException invalidNestedObjectPathForPredicate(String var1, List<String> var2);

    @Message(id=400606, value="Field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.")
    public SearchException cannotFilterAggregationOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=400607, value="The index field template '%1$s' was added twice. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.")
    public SearchException indexSchemaFieldTemplateNameConflict(String var1, @Param EventContext var2);

    @Message(id=400608, value="Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.")
    public SearchException invalidFieldValueType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400609, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForIndexing(String var1, @Param EventContext var2);

    @Message(id=400610, value="Invalid type: the index root is not an object field.")
    public SearchException invalidIndexElementTypeRootIsNotObjectField();

    @Message(id=400611, value="Invalid type: '%1$s' is a value field, not an object field.")
    public SearchException invalidIndexElementTypeValueFieldIsNotObjectField(String var1);

    @Message(id=400612, value="Invalid type: '%1$s' is an object field, not a value field.")
    public SearchException invalidIndexElementTypeObjectFieldIsNotValueField(String var1);
}

