/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchFailingFieldCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchFailingIdCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexFieldComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexRootComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchScopeModel {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Set<ElasticsearchIndexModel> indexModels;
    private final Set<String> hibernateSearchIndexNames;
    private final Map<String, URLEncodedString> mappedTypeToElasticsearchIndexNames;

    public ElasticsearchScopeModel(Set<ElasticsearchIndexModel> indexModels) {
        this.indexModels = indexModels;
        this.hibernateSearchIndexNames = new LinkedHashSet<String>();
        this.mappedTypeToElasticsearchIndexNames = new LinkedHashMap<String, URLEncodedString>();
        for (ElasticsearchIndexModel model : indexModels) {
            this.hibernateSearchIndexNames.add(model.hibernateSearchName());
            this.mappedTypeToElasticsearchIndexNames.put(model.getMappedTypeName(), model.getNames().getRead());
        }
    }

    public Set<String> getMappedTypeNames() {
        return this.mappedTypeToElasticsearchIndexNames.keySet();
    }

    public Set<String> getHibernateSearchIndexNames() {
        return this.hibernateSearchIndexNames;
    }

    public Collection<URLEncodedString> getElasticsearchIndexNames() {
        return this.mappedTypeToElasticsearchIndexNames.values();
    }

    public Map<String, URLEncodedString> getMappedTypeToElasticsearchIndexNames() {
        return this.mappedTypeToElasticsearchIndexNames;
    }

    public EventContext getIndexesEventContext() {
        return EventContexts.fromIndexNames(this.getHibernateSearchIndexNames());
    }

    public ElasticsearchScopedIndexRootComponent<ToDocumentIdentifierValueConverter<?>> getIdDslConverter() {
        Iterator<ElasticsearchIndexModel> iterator = this.indexModels.iterator();
        ElasticsearchIndexModel indexModelForSelectedIdConverter = null;
        ToDocumentIdentifierValueConverter<?> selectedIdConverter = null;
        ElasticsearchScopedIndexRootComponent scopedIndexFieldComponent = new ElasticsearchScopedIndexRootComponent();
        while (iterator.hasNext()) {
            ElasticsearchIndexModel indexModel = iterator.next();
            ToDocumentIdentifierValueConverter<?> idConverter = indexModel.getIdDslConverter();
            if (selectedIdConverter == null) {
                indexModelForSelectedIdConverter = indexModel;
                selectedIdConverter = idConverter;
                scopedIndexFieldComponent.setComponent(selectedIdConverter);
                continue;
            }
            if (selectedIdConverter.isCompatibleWith(idConverter)) continue;
            ElasticsearchFailingIdCompatibilityChecker failingCompatibilityChecker = new ElasticsearchFailingIdCompatibilityChecker(selectedIdConverter, idConverter, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedIdConverter.hibernateSearchName(), indexModel.hibernateSearchName()}));
            scopedIndexFieldComponent.setIdConverterCompatibilityChecker(failingCompatibilityChecker);
        }
        return scopedIndexFieldComponent;
    }

    public <T> ElasticsearchScopedIndexFieldComponent<T> getSchemaNodeComponent(String absoluteFieldPath, IndexSchemaFieldNodeComponentRetrievalStrategy<T> componentRetrievalStrategy) {
        ElasticsearchIndexModel indexModelForSelectedSchemaNode = null;
        ElasticsearchIndexSchemaFieldNode<?> selectedSchemaNode = null;
        ElasticsearchScopedIndexFieldComponent<T> scopedIndexFieldComponent = new ElasticsearchScopedIndexFieldComponent<T>();
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            ElasticsearchIndexSchemaFieldNode<?> schemaNode = indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (schemaNode == null) continue;
            T component = componentRetrievalStrategy.extractComponent(schemaNode);
            if (selectedSchemaNode == null) {
                selectedSchemaNode = schemaNode;
                indexModelForSelectedSchemaNode = indexModel;
                scopedIndexFieldComponent.setComponent(component);
                continue;
            }
            if (!componentRetrievalStrategy.hasCompatibleCodec(scopedIndexFieldComponent.getComponent(), component)) {
                throw componentRetrievalStrategy.createCompatibilityException(absoluteFieldPath, scopedIndexFieldComponent.getComponent(), component, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedSchemaNode.hibernateSearchName(), indexModel.hibernateSearchName()}));
            }
            ElasticsearchFailingFieldCompatibilityChecker failingCompatibilityChecker = new ElasticsearchFailingFieldCompatibilityChecker(absoluteFieldPath, scopedIndexFieldComponent.getComponent(), component, EventContexts.fromIndexNames((String[])new String[]{indexModelForSelectedSchemaNode.hibernateSearchName(), indexModel.hibernateSearchName()}), componentRetrievalStrategy);
            if (!componentRetrievalStrategy.hasCompatibleConverter(scopedIndexFieldComponent.getComponent(), component)) {
                scopedIndexFieldComponent.setConverterCompatibilityChecker(failingCompatibilityChecker);
            }
            if (componentRetrievalStrategy.hasCompatibleAnalyzer(scopedIndexFieldComponent.getComponent(), component)) continue;
            scopedIndexFieldComponent.setAnalyzerCompatibilityChecker(failingCompatibilityChecker);
        }
        if (selectedSchemaNode == null) {
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
        return scopedIndexFieldComponent;
    }

    public boolean hasSchemaObjectNodeComponent(String absoluteFieldPath) {
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            ElasticsearchIndexSchemaObjectFieldNode objectNode = indexModel.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (objectNode == null) continue;
            return true;
        }
        return false;
    }

    public void checkNestedField(String absoluteFieldPath) {
        AbstractElasticsearchIndexSchemaFieldNode schemaNode;
        boolean found = false;
        for (ElasticsearchIndexModel indexModel : this.indexModels) {
            schemaNode = indexModel.getObjectFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
            if (schemaNode == null) continue;
            found = true;
            if (ObjectFieldStorage.NESTED.equals((Object)schemaNode.getStorage())) continue;
            throw log.nonNestedFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
        }
        if (!found) {
            for (ElasticsearchIndexModel indexModel : this.indexModels) {
                schemaNode = indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY);
                if (schemaNode == null) continue;
                throw log.nonObjectFieldForNestedQuery(absoluteFieldPath, indexModel.getEventContext());
            }
            throw log.unknownFieldForSearch(absoluteFieldPath, this.getIndexesEventContext());
        }
    }

    public String getNestedDocumentPath(String absoluteFieldPath) {
        Optional<Object> nestedDocumentPath = this.indexModels.stream().map(indexModel -> indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY)).filter(Objects::nonNull).map(fieldNode -> Optional.ofNullable(fieldNode.getNestedPath())).reduce((nestedDocumentPath1, nestedDocumentPath2) -> {
            if (Objects.equals(nestedDocumentPath1, nestedDocumentPath2)) {
                return nestedDocumentPath1;
            }
            throw log.conflictingNestedDocumentPaths(absoluteFieldPath, nestedDocumentPath1.orElse(null), nestedDocumentPath2.orElse(null), this.getIndexesEventContext());
        }).orElse(Optional.empty());
        return nestedDocumentPath.orElse(null);
    }

    public List<String> getNestedPathHierarchyForField(String absoluteFieldPath) {
        Optional nestedDocumentPath = this.indexModels.stream().map(indexModel -> indexModel.getFieldNode(absoluteFieldPath, IndexFieldFilter.INCLUDED_ONLY)).filter(Objects::nonNull).map(node -> Optional.ofNullable(node.getNestedPathHierarchy())).reduce((nestedDocumentPath1, nestedDocumentPath2) -> {
            if (Objects.equals(nestedDocumentPath1, nestedDocumentPath2)) {
                return nestedDocumentPath1;
            }
            throw log.conflictingNestedDocumentPathHierarchy(absoluteFieldPath, nestedDocumentPath1.orElse(null), nestedDocumentPath2.orElse(null), this.getIndexesEventContext());
        }).orElse(Optional.empty());
        return nestedDocumentPath.orElse(Collections.emptyList());
    }

    public List<String> getNestedPathHierarchyForObject(String absoluteObjectPath) {
        Optional nestedDocumentPath = this.indexModels.stream().map(indexModel -> indexModel.getObjectFieldNode(absoluteObjectPath, IndexFieldFilter.INCLUDED_ONLY)).filter(Objects::nonNull).map(node -> Optional.ofNullable(node.getNestedPathHierarchy())).reduce((nestedDocumentPath1, nestedDocumentPath2) -> {
            if (Objects.equals(nestedDocumentPath1, nestedDocumentPath2)) {
                return nestedDocumentPath1;
            }
            throw log.conflictingNestedDocumentPathHierarchy(absoluteObjectPath, nestedDocumentPath1.orElse(null), nestedDocumentPath2.orElse(null), this.getIndexesEventContext());
        }).orElse(Optional.empty());
        return nestedDocumentPath.orElse(Collections.emptyList());
    }
}

