/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexFieldComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregationCollector;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchUserProvidedJsonAggregation;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchSearchAggregationBuilderFactory
implements SearchAggregationBuilderFactory<ElasticsearchSearchAggregationCollector> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final AggregationBuilderFactoryRetrievalStrategy AGGREGATION_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new AggregationBuilderFactoryRetrievalStrategy();
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchScopeModel scopeModel;

    public ElasticsearchSearchAggregationBuilderFactory(ElasticsearchSearchContext searchContext, ElasticsearchScopeModel scopeModel) {
        this.searchContext = searchContext;
        this.scopeModel = scopeModel;
    }

    public <A> void contribute(ElasticsearchSearchAggregationCollector collector, AggregationKey<A> key, SearchAggregation<A> aggregation) {
        if (!(aggregation instanceof ElasticsearchSearchAggregation)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherAggregations(aggregation);
        }
        ElasticsearchSearchAggregation casted = (ElasticsearchSearchAggregation)aggregation;
        if (!this.scopeModel.getHibernateSearchIndexNames().equals(casted.getIndexNames())) {
            throw log.aggregationDefinedOnDifferentIndexes(aggregation, casted.getIndexNames(), this.scopeModel.getHibernateSearchIndexNames());
        }
        collector.collectAggregation(key, casted);
    }

    public <T> TermsAggregationBuilder<T> createTermsAggregationBuilder(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldAggregationBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, AGGREGATION_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        this.checkConverterCompatibility(fieldComponent, convert);
        return fieldComponent.getComponent().createTermsAggregationBuilder(this.searchContext, absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath), expectedType, convert);
    }

    public <T> RangeAggregationBuilder<T> createRangeAggregationBuilder(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldAggregationBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, AGGREGATION_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        this.checkConverterCompatibility(fieldComponent, convert);
        return fieldComponent.getComponent().createRangeAggregationBuilder(this.searchContext, absoluteFieldPath, this.scopeModel.getNestedPathHierarchyForField(absoluteFieldPath), expectedType, convert);
    }

    public SearchAggregationBuilder<JsonObject> fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonAggregation.Builder(this.searchContext, jsonObject);
    }

    public SearchAggregationBuilder<JsonObject> fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.searchContext.getUserFacingGson().fromJson(jsonString, JsonObject.class));
    }

    private void checkConverterCompatibility(ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldAggregationBuilderFactory> fieldComponent, ValueConvert convert) {
        switch (convert) {
            case NO: {
                break;
            }
            default: {
                fieldComponent.getConverterCompatibilityChecker().failIfNotCompatible();
            }
        }
    }

    private static class AggregationBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<ElasticsearchFieldAggregationBuilderFactory> {
        private AggregationBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public ElasticsearchFieldAggregationBuilderFactory extractComponent(ElasticsearchIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.type().getAggregationBuilderFactory();
        }

        @Override
        public boolean hasCompatibleCodec(ElasticsearchFieldAggregationBuilderFactory component1, ElasticsearchFieldAggregationBuilderFactory component2) {
            return component1.hasCompatibleCodec(component2);
        }

        @Override
        public boolean hasCompatibleConverter(ElasticsearchFieldAggregationBuilderFactory component1, ElasticsearchFieldAggregationBuilderFactory component2) {
            return component1.hasCompatibleConverter(component2);
        }

        @Override
        public boolean hasCompatibleAnalyzer(ElasticsearchFieldAggregationBuilderFactory component1, ElasticsearchFieldAggregationBuilderFactory component2) {
            return true;
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, ElasticsearchFieldAggregationBuilderFactory component1, ElasticsearchFieldAggregationBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForAggregation(absoluteFieldPath, component1, component2, context);
        }
    }
}

