/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchNestablePredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<String> PATH_ACCESSOR = JsonAccessor.root().property("path").asString();
    private static final JsonAccessor<JsonObject> QUERY_ACCESSOR = JsonAccessor.root().property("query").asObject();

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        if (expectedParentNestedPath != null && !nestedPathHierarchy.contains(expectedParentNestedPath)) {
            throw log.invalidNestedObjectPathForPredicate(expectedParentNestedPath, this.getFieldPathsForErrorMessage());
        }
    }

    @Override
    public JsonObject build(ElasticsearchSearchPredicateContext context) {
        int hierarchyLastIndex;
        String path;
        String expectedNestedPath;
        this.checkNestableWithin(context.getNestedPath());
        List<String> nestedPathHierarchy = this.getNestedPathHierarchy();
        String string = expectedNestedPath = nestedPathHierarchy.isEmpty() ? null : nestedPathHierarchy.get(nestedPathHierarchy.size() - 1);
        if (Objects.equals(context.getNestedPath(), expectedNestedPath)) {
            return super.build(context);
        }
        ElasticsearchSearchPredicateContext contextAfterImplicitNesting = context.withNestedPath(expectedNestedPath);
        JsonObject result = super.build(contextAfterImplicitNesting);
        for (int i = hierarchyLastIndex = nestedPathHierarchy.size() - 1; i >= 0 && !(path = nestedPathHierarchy.get(i)).equals(context.getNestedPath()); --i) {
            JsonObject innerObject = new JsonObject();
            PATH_ACCESSOR.set(innerObject, path);
            QUERY_ACCESSOR.set(innerObject, result);
            JsonObject outerObject = new JsonObject();
            outerObject.add("nested", (JsonElement)innerObject);
            result = outerObject;
        }
        return result;
    }

    protected abstract List<String> getNestedPathHierarchy();

    protected abstract List<String> getFieldPathsForErrorMessage();
}

